package org.bif.entity.bidAuth;



import org.bif.protocol.bidComm.BidCommPlaintext;
import org.bif.protocol.enums.bidAuth.AuthTypeEnum;
import org.bif.protocol.enums.bidComm.PlaintextTypeEnum;

//   请求信息
public class BidAuthRequestEntity extends BidCommPlaintext {


    public BidAuthRequestEntity(String id,
                                String bid,
                                String publicKey){
        super();
        BidAuthRequestContent content = new BidAuthRequestContent(bid,publicKey);
        this.setType(PlaintextTypeEnum.BIDAUTH.getType());
        this.setId(id);
        this.setContent(content);
    }

    public BidAuthRequestEntity(){
        super();
    }

    //   CONTENT内容
    public static class BidAuthRequestContent   {

        private String type;
        private String bid;
        private String publicKey;

        public BidAuthRequestContent(){
        }

        public BidAuthRequestContent( String bid, String publicKey){
            this.type = AuthTypeEnum.REQUEST.getType();
            this.bid = bid;
            this.publicKey = publicKey;
        }

        public String getType() {
            return type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getBid() {
            return bid;
        }

        public void setBid(String bid) {
            this.bid = bid;
        }

        public String getPublicKey() {
            return publicKey;
        }

        public void setPublicKey(String publicKey) {
            this.publicKey = publicKey;
        }
    }

}
