package org.bif.common.utils;

import cn.caict.encryption.key.PrivateKey;
import cn.caict.encryption.key.PublicKey;
import cn.caict.encryption.utils.base.Base58;


import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;



public class SignUtilTest {

    private static String TEST_PATH = "bif-protocol/src/test/";

    private static String PRIVATE_KEY = "priSPKp8oiiAXGZaXFBMKEAoL2b6J6UDQCw4x39ereXYtyAejM";

    private static String PUBLIC_KEY = "b06566f76733ae048fda721d47afe8780b572636496c93253db86dc8d5427fc54e9a06";


    private static String readFileToString(String filename) throws IOException {
        FileInputStream in = new FileInputStream(new File(filename));
        ByteArrayOutputStream out = new ByteArrayOutputStream(100000);

        byte[] buffer = new byte[100000];
        int bytes;
        while ((bytes = in.read(buffer)) != -1) {
            out.write(buffer, 0, bytes);
        }
        in.close();
        return out.toString();
    }



    private static String test() throws Exception{

        String docStr = " {\n" +
                "                        \"issuer\": \"did:bid:efJgt44mNDewKK1VEN454R17cjso3mSG\",\n" +
                "                        \"issuanceDate\": \"2021-01-20T12:01:20Z\",\n" +
                "                        \"effectiveDate\": \"2021-01-20T12:01:20Z\",\n" +
                "                        \"expirationDate\": \"2021-04-02T12:01:20Z\",\n" +
                "                        \"revocationId\": \"did:bid:efJgt44mNDewKK1VEN454R17cjso3mSG#revocation\",\n" +
                "                        \"credentialSubject\": {\n" +
                "                            \"id\": \"did:bid:efJgt44mNDewKK1VEN454R17cjso3mSG\",\n" +
                "                            \"type\": 202,\n" +
                "                            \"name\": \"asc\",\n" +
                "                            \"content\": { }\n" +
                "                        }\n" +
                "                    }\n";
        String retStr = SignUtil.formatSignData(docStr);
        //String retStr = formatSignData(docStr);
        //System.out.println(retStr);
        return retStr;
    }


    private static String ed25519Sign(String fileName){

        try {
            String bidJsonStr = readFileToString(TEST_PATH + fileName);
            byte[] waitSignData = SignUtil.formatWaitSignDataByte(bidJsonStr);

            PrivateKey privateObj = new PrivateKey(PRIVATE_KEY);
            byte[] signByte = privateObj.sign(waitSignData);
            String signData = Base58.encode(signByte);
            return signData;
        }catch (Exception e){
            System.out.println(e.getMessage());
        }
        return null;
    }

    private static boolean verifySign(String base58SignData,String fileName){
        try {
            String bidJsonStr = readFileToString(TEST_PATH  + fileName);
            byte[] waitSignData = SignUtil.formatWaitSignDataByte(bidJsonStr);
            return SignUtil.verifySign(base58SignData,waitSignData,PUBLIC_KEY);
        }catch (Exception e){
            System.out.println(e.getMessage());
        }
        return false;
    }

    private static void testSignAndVerify(){
        String credentialFileName = "credential";
        String bidFileName = "bid";
        String signData = ed25519Sign(bidFileName);
        if(verifySign(signData,bidFileName)){
            System.out.println("verify OK!");
        }else{
            System.out.println("verify failed!");
        }
    }

    private static String getWaitSignData() throws Exception{
        String credentialStr = readFileToString(TEST_PATH + "credential");
        String bidStr = readFileToString(TEST_PATH + "bid");
        String waitSignData = SignUtil.formatWaitSignData(credentialStr);

        /*
        String base58Signature = Base58.encode(waitSignData.getBytes());
        String DecodeSign = new String(Base58.decode(base58Signature));
        if(!DecodeSign.equals(waitSignData)){
            throw new Exception("不相等");
        }

         */
        System.out.println(waitSignData);
        return waitSignData;
    }


    public static void main(String[] args) {

        try {
            getWaitSignData();
            //testSignAndVerify();

        }catch (Exception e){
            System.out.println(e.getMessage());
        }

    }
}
