package org.bif.common.utils;


import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTCreator;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.interfaces.Claim;
import com.auth0.jwt.interfaces.DecodedJWT;
import com.auth0.jwt.interfaces.Payload;

import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Map;

public class JwtUtil {

    public static String createToken(Map<String,Object> header,
                              Map<String,Object> payload,
                              Algorithm alg){
        String token = JWT.create()
                .withHeader(header)
                .withPayload(payload)
                .sign(alg);
        System.out.println(token);
        return token;
    }

    public static String getHeader(String token){
        DecodedJWT jwt = JWT.decode(token);
        return jwt.getHeader();

    }

    public static String getPayloadToken(String token){
        DecodedJWT jwt = JWT.decode(token);
        return jwt.getPayload();
    }



    public static String getPayloadStr(String token){
        return new String(Base64.getUrlDecoder().decode(getPayloadToken(token)), StandardCharsets.UTF_8);
    }

    public static String getPayloadStr(DecodedJWT jwt){
        return new String(Base64.getUrlDecoder().decode(jwt.getPayload()), StandardCharsets.UTF_8);
    }

    public static String getHeaderToken(String token){
        DecodedJWT jwt = JWT.decode(token);
        return jwt.getHeader();
    }

    public static String getHeaderStr(String token){
        return new String(Base64.getUrlDecoder().decode(getHeaderToken(token)), StandardCharsets.UTF_8);
    }

    public static String getHeaderStr(DecodedJWT jwt){
        return new String(Base64.getUrlDecoder().decode(jwt.getHeader()), StandardCharsets.UTF_8);
    }

    public static DecodedJWT getDecode(String token){
        return JWT.decode(token);
    }

    //返回payload某个key的value，返回类型boolen=Claim.asBoolean()
    //asInt(),asDouble,asLong,asString,asDate,as(class),asMap(),asArray(class),asList(class)
    public static Claim getClaim(String token, String key){
        DecodedJWT jwt = JWT.decode(token);
        return jwt.getClaim(key);
    }

    public static Map<String,Object> getClaimMap(String token, String key){
        DecodedJWT jwt = JWT.decode(token);
        return jwt.getClaim(key).asMap();
    }

    public static String getSignatureToken(String token){
        DecodedJWT jwt = JWT.decode(token);
        return jwt.getSignature();
    }

    public static String getSignatureStr(String token){
        return new String(Base64.getUrlDecoder().decode(getSignatureToken(token)), StandardCharsets.UTF_8);
    }

    public static String formatJwtToken(String header,String payload,String signature){
        return String.format("%s.%s.%s", header, payload, signature);
    }

    public static String formatJwtSignData(String header,String payload){
        return String.format("%s.%s", header, payload);
    }

    public static String format2JwtStr(String str){
        return Base64UrlUtil.base64Encode(str);
    }
}
