package org.bif.common.utils;


import org.bif.entity.BIDDocumentEntity;
import org.bif.protocol.bid.BidProtocol;

import java.util.Collection;

public class CheckUtil {

    public static boolean nonNull(Object obj){
        return !Tools.isNull(obj);
    }

    public static boolean nonList(Collection<?> coll){
        return !Tools.isNullByList(coll);
    }

    public static boolean  checkBidProtocol(BIDDocumentEntity bidDocumentEntity){
        BidProtocol bidData = bidDocumentEntity.getBidProtocol();
        return nonList(bidData.getContext()) && nonNull(bidData.getVersion()) &&
                nonNull(bidData.getId()) && nonList(bidData.getPublicKey()) &&
                nonList(bidData.getAuthentication()) && nonNull(bidData.getExtension()) &&
                nonNull(bidData.getExtension().getTtl()) && nonNull(bidData.getExtension().getType()) &&
                nonList(bidData.getExtension().getAttributes()) && nonNull(bidData.getCreated()) &&
                nonNull(bidData.getUpdated());
    }

    public static boolean  checkBidProtocol(BidProtocol bidData){
        return nonList(bidData.getContext()) && nonNull(bidData.getVersion()) &&
                nonNull(bidData.getId()) && nonList(bidData.getPublicKey()) &&
                nonList(bidData.getAuthentication()) && nonNull(bidData.getExtension()) &&
                nonNull(bidData.getExtension().getTtl()) && nonNull(bidData.getExtension().getType()) &&
                nonList(bidData.getExtension().getAttributes()) && nonNull(bidData.getCreated()) &&
                nonNull(bidData.getUpdated());
    }

}
