package org.bif.test;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.fasterxml.jackson.annotation.JsonCreator;
import org.bif.common.utils.SignUtil;
import org.bif.entity.BIDDocumentEntity;
import org.bif.protocol.bid.BidProtocol;
import org.bif.protocol.bid.Proof;
import org.bif.protocol.bid.attribute.AttributeCommon;
import org.bif.protocol.bid.attribute.AttributeCredential;
import org.bif.protocol.constant.BidProtocolConstants;
import org.bif.protocol.enums.bid.ServiceTypeEnum;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class test {

    public static  void main(String[] args) {
        //commonBid();
        //ccBid();
        bidTest();
    }

    public static void  commonBid(){
        BIDDocumentEntity bidDocEntity = new BIDDocumentEntity();
        String documentId = "did:bid:efic56wX9xrRN3nMhob2iswohNzq4hyr";
        String endpoint = "https://www.w3.org/ns/did/v1";
        bidDocEntity.createBIDDocumentEntity(documentId);
        bidDocEntity.setExType(101);
        bidDocEntity.addPublicKey(documentId + "#key-1","Ed25519",documentId,"publicKey");
        bidDocEntity.addDidRevocationService("did:bid:ef24NBA7au48UTZrUNRHj2p3bnRzF3YC#revocation",endpoint);
        bidDocEntity.addAuthentication(documentId + "#key-auth");
        bidDocEntity.addExRecovery(documentId + "#key-recovery");
        //bidDocEntity.addExAttribute("contract","智能合约地址",true,"text","did:bid:efJgt44mNDewKK1VEN454R17cjso3mSG");
        AttributeCredential credential = new AttributeCredential();
        credential.setIssuer(documentId);
        credential.setIssuanceDate("2021-01-20T12:01:20Z");
        credential.setEffectiveDate("2021-01-20T12:01:20Z");
        credential.setExpirationDate("2021-01-20T12:01:20Z");
        credential.setRevocationId(documentId);
        AttributeCredential.CredentialSubject credentialSubject = new AttributeCredential.CredentialSubject();
        credentialSubject.setContent("{\\\"bvalue\\\":\\\"abc\\\",\\\"encrypt\\\":0,\\\"cformat\\\":\\\"text\\\",\\\"akey\\\":\\\"identType\\\",\\\"dalue\\\":\\\"IdentBid\\\"}");
        credentialSubject.setDescription("abcd");
        credentialSubject.setId(documentId);
        credentialSubject.setType(202);
        credentialSubject.setName("beijing");
        credential.setCredentialSubject(credentialSubject);
        Proof proof = new Proof();
        proof.setSignatureValue("abc");
        proof.setCreator("eee");
        List<Proof> proofList = new ArrayList<>();
        proofList.add(proof);
        credential.setProof(proofList);
        bidDocEntity.addExCredentialAttribute(credential);
        bidDocEntity.addExAcsn("by01");
        bidDocEntity.addExDelegateSign("did:bid:efic56wX9xrRN3nMhob2iswohNzq4hyr#key-1","eyJhbGciOiJSUzI1NiIsImI2NCI6ZmFsc2UsImNyaXQiOlsiYjY0Il19");
        bidDocEntity.addDidSubResolveService(documentId,"1.0.0",1,"192.168.1.1",8080);
        bidDocEntity.addDidDecryptService("did:bid:ef24NBA7au48UTZrUNRHj2p3bnRzF3YC#decrypt",endpoint);
        bidDocEntity.addExVerifiableCredential("did:bid:efJgt44mND344rrDDwN454R17cjso3mSG",201);
        bidDocEntity.addDidStorageService("did:bid:ef24NBA7au48UTZrUNRHj2p3bnRzF3YC#storage",endpoint);
        bidDocEntity.setProof("did:bid:efJgt44mNDewKK1VEN454R17cjso3mSG#key-1","eyJhbGciOiJSUzI1NiIsImI2NCI6ZmFsc2UsImNyaXQiOlsiYjY0Il19");
        //System.out.println(JSON.toJSONString(bidDocEntity.getBidProtocol()));
        bidDocEntity.addExAcsn("by02");
        bidDocEntity.deleteService(ServiceTypeEnum.SERVICE_SUB_RESOLVER.getType());
        BidProtocol bidProtocol = bidDocEntity.getBidProtocol();
        //AttributeCredential credentialTemp = (AttributeCredential)bidProtocol.getExtension().getAttributes().get(0);
        //String str = SignUtil.formatSignData(JSON.toJSONString(credentialTemp));

        String str = JSON.toJSONString(bidDocEntity.getBidProtocol());
        /*
        BidProtocol doc = JSON.parseObject(str, BidProtocol.class);
        String temp = JSON.toJSONString(doc.getExtension().getAttributes());
        List<AttributeCommon> ipList = JSON.parseArray(temp, AttributeCommon.class);

         */

        System.out.println(JSON.toJSONString(str));
    }

    public static void  ccBid(){
        BIDDocumentEntity bidDocEntity = new BIDDocumentEntity();
        String documentId = "did:bid:by01";
        String endpoint = "https://www.w3.org/ns/did/v1";
        bidDocEntity.createBIDDocumentEntity(documentId);
        bidDocEntity.setExType(206);
        //bidDocEntity.addPublicKey(documentId + "#key-1","Ed25519",documentId,"publicKey");
        bidDocEntity.addDidRevocationService("did:bid:ef24NBA7au48UTZrUNRHj2p3bnRzF3YC#revocation",endpoint);
        //bidDocEntity.addAuthentication(documentId + "#key-auth");
        //bidDocEntity.addExRecovery(documentId + "#key-recovery");
        bidDocEntity.setExTtl(BidProtocolConstants.TTL);
        //bidDocEntity.addExAttribute("contract","智能合约地址",false,"text","did:bid:efJgt44mNDewKK1VEN454R17cjso3mSG");
        bidDocEntity.addExDelegateSign("did:bid:efJgt44mNDewKK1VEN454R17cjso3mSG#key-1","eyJhbGciOiJSUzI1NiIsImI2NCI6ZmFsc2UsImNyaXQiOlsiYjY0Il19");
        bidDocEntity.addDidSubResolveService("did:bid:ef24NBA7au48UTZrUNRHj2p3bnRzF3YC#subResolveService","1.0.0",3,"192.168.1.1",8080);
        bidDocEntity.setProof("did:bid:efJgt44mNDewKK1VEN454R17cjso3mSG#key-1","eyJhbGciOiJSUzI1NiIsImI2NCI6ZmFsc2UsImNyaXQiOlsiYjY0Il19");
        System.out.println(JSON.toJSONString(bidDocEntity.getBidProtocol()));
    }

    public static void  bidTest(){
        String bidJsonStr = "{\"@context\":[\"https://www.w3.org/ns/did/v1\"],\"authentication\":[\"did:bid:8390\"],\"created\":\"2021-11-30T01:45:48Z\",\"extension\":{\"attributes\":[{\"desc\":\"骨干节点Bid\",\"encrypt\":0,\"format\":\"text\",\"key\":\"backboneNodeBID\",\"value\":\"did:bid:efu7dNdtKa1mQMLyadHyQV1X9s1wJzzx\"},{\"desc\":\"随机数\",\"encrypt\":0,\"format\":\"text\",\"key\":\"random\",\"value\":\"C8CEAEE9D2C7EBFD443F7239E8A3C173\"},{\"desc\":\"contact信息\",\"encrypt\":0,\"format\":\"text\",\"key\":\"secretInfo\",\"value\":\"9949B620115B4F2AB8063BBB107E7868A2BEE2079D52DF517033B6F849CE291BBB8747824EA982DAD617F590265C2B67201D5F9099B498A17DF8FC2DA09324\"},{\"desc\":\"链名称\",\"encrypt\":0,\"format\":\"text\",\"key\":\"chainName\",\"value\":\"hi7y链\"},{\"desc\":\"子链类型\",\"encrypt\":0,\"format\":\"text\",\"key\":\"subChainType\",\"value\":\"0\"},{\"desc\":\"链架构类型\",\"encrypt\":0,\"format\":\"text\",\"key\":\"architectureId\",\"value\":\"10007\"},{\"desc\":\"行业名称\",\"encrypt\":0,\"format\":\"text\",\"key\":\"industry\",\"value\":\"B\"},{\"desc\":\"套餐ID\",\"encrypt\":0,\"format\":\"text\",\"key\":\"comboId\"},{\"desc\":\"创世账户地址\",\"encrypt\":0,\"format\":\"text\",\"key\":\"genesisAccount\",\"value\":\"did:bid:efGZ1DGA3jk916NaPuScgCpcfztDjzj2\"},{\"desc\":\"创世账户初始化燃料数\",\"encrypt\":0,\"format\":\"text\",\"key\":\"genesisAmount\",\"value\":\"10000000000000\"},{\"desc\":\"积分单位\",\"encrypt\":0,\"format\":\"text\",\"key\":\"unit\",\"value\":\"unit\"},{\"desc\":\"精度\",\"encrypt\":0,\"format\":\"text\",\"key\":\"precision\",\"value\":\"2\"},{\"desc\":\"燃料单价\",\"encrypt\":0,\"format\":\"text\",\"key\":\"feeGasPrice\",\"value\":\"1\"},{\"desc\":\"首次出块奖励数\",\"encrypt\":0,\"format\":\"text\",\"key\":\"rewardInitValue\",\"value\":\"100\"},{\"desc\":\"链口号\",\"encrypt\":0,\"format\":\"text\",\"key\":\"genesisSlogan\",\"value\":\"77nr链\"},{\"desc\":\"子链访问URL\",\"encrypt\":0,\"format\":\"text\",\"key\":\"visitUrl\",\"value\":\"http://www.baidu.com/\"},{\"desc\":\"开放状态\",\"encrypt\":0,\"format\":\"text\",\"key\":\"publicStatus\",\"value\":\"1\"},{\"desc\":\"链码\",\"encrypt\":0,\"format\":\"text\",\"key\":\"chainCode\",\"value\":\"8390\"}],\"ttl\":86400,\"type\":206},\"id\":\"did:bid:8390\",\"service\":[{\"id\":\"did:bid:8390#subResolve\",\"port\":80,\"protocol\":1,\"serverType\":1,\"serviceEndpoint\":\"192.168.1.1\",\"type\":\"DIDSubResolver\",\"version\":\"1.0.0\"},{\"id\":\"did:bid:8390#subResolve-1\",\"port\":80,\"protocol\":1,\"serverType\":1,\"serviceEndpoint\":\"1111:0410:0000:1234:FB00:1400:5000:45FF\",\"type\":\"DIDSubResolver\",\"version\":\"1.0.0\"},{\"id\":\"did:bid:8390#subResolve-2\",\"protocol\":2,\"serverType\":0,\"serviceEndpoint\":\"http://www.baidu.com/\",\"type\":\"DIDSubResolver\",\"version\":\"1.0.0\"}],\"updated\":\"2021-11-30T01:45:48Z\",\"version\":\"1.0.0\"}";
        BidProtocol bidProtocol = JSON.parseObject(bidJsonStr,BidProtocol.class);
        BIDDocumentEntity bidDocEntity = new BIDDocumentEntity();
        bidDocEntity.setBidProtocol(bidProtocol);
        bidDocEntity.deleteService(ServiceTypeEnum.SERVICE_SUB_RESOLVER.getType());
        System.out.println(JSON.toJSONString(bidJsonStr));
    }
}
