package org.bif.test;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import org.bif.entity.bidCredential.BidPvEntity;
import org.bif.entity.bidCredential.BidCrEntity;
import org.bif.entity.bidCredential.BidVpEntity;
import org.bif.protocol.bidCredential.BidCredential;
import org.bif.protocol.bidCredential.BidVp;
import org.bif.protocol.bidCredential.BidVpRequirement;
import org.bif.protocol.constant.BidCredentialConstants;
import org.bif.protocol.enums.bidCredential.ParseFunEnum;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class BidCredentialTest {



    public static  void main(String[] args) {
        credentialTest();
    }




    public static void credentialTest(){
        try {
            //1.创建证书
            BidCredential bidCredential = buildCredential();
            System.out.println("1.-credential:" + JSON.toJSONString(bidCredential));

            //2.资质验证请求
            BidCrEntity requestEntity = buildCredentialRequest();
            System.out.println("2.-requestEntity:" + JSON.toJSONString(requestEntity));

            //3.构造可信数字声明
            BidVpEntity bidCredentialVp = buildCredentialVp();
            System.out.println("3.-bidCredentialVp:" + JSON.toJSONString(bidCredentialVp));

            //3.构造验证通过证明
            BidPvEntity bidPvEntity = buildCredentialPassEntity();
            System.out.println("4.-bidCredentialPassEntity:" + JSON.toJSONString(bidPvEntity));


        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static BidCredential buildCredential(){
        String id = "http://example.edu/credentials/1872";
        BidCredential bidCredential = new BidCredential(id);
        String bid = "did:bid:zfwwYEeDpiNo7f9aXN7uLA3FMbguSTNv";
        bidCredential.getContext().add("https://www.w3.org/2018/credentials/examples/v1");
        bidCredential.setId(id);
        bidCredential.getType().add("AlumniCredential");
        bidCredential.setIssuer(bid);
        bidCredential.setIssuanceDate("2010-01-01T19:23:24Z");
        bidCredential.setTemplateId("20100101T23Nedex");
        bidCredential.setValidBefore("2010-01-02T19:23:24Z");
        String subjectId = "did:bid:123456";
        AlumniOfCredentialSubject credentialSubject = new AlumniOfCredentialSubject();
        credentialSubject.setId(subjectId);
        credentialSubject.setOtherData("other123");
        bidCredential.setCredentialSubject(credentialSubject);
        bidCredential.setRevocationId("20100101NN30d398");
        bidCredential.setParseType(BidCredentialConstants.DIRECT);
        return bidCredential;
    }


    public static class AlumniOfCredentialSubject {
        private String id;
        private String otherData;

        public String getId() {
            return id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getOtherData() {
            return otherData;
        }

        public void setOtherData(String otherData) {
            this.otherData = otherData;
        }
    }

    public static BidCrEntity buildCredentialRequest(){
        String bid = "did:bid:zfwwYEeDpiNo7f9aXN7uLA3FMbguSTNv";
        String id = "http://example.edu/credentials/1872";
        BidCrEntity requestEntity = new BidCrEntity(id);
        requestEntity.setVerifier(bid);
        requestEntity.setSender(bid);
        //requirement
        BidCrEntity.BidCredentialRequirements requirement = new BidCrEntity.BidCredentialRequirements();
        //requirement - presentation
        BidCrEntity.BidCredentialPresentation presentation = new BidCrEntity.BidCredentialPresentation();
        presentation.setComposeType(Arrays.asList(BidCredentialConstants.DIRECT));
        requirement.setPresentation(presentation);
        //requirement - credentials
        List<BidVpRequirement> credentialRequire = new ArrayList<>();
        AlumniRequire alumniRequire = new AlumniRequire();
        alumniRequire.setType("AlumniCredential");
        alumniRequire.setMinVersion("1.0");
        alumniRequire.setMaxVersion("2.0");
        credentialRequire.add(alumniRequire);
        requirement.setCredentials(new ArrayList<>());
        requirement.getCredentials().add(credentialRequire);
        requestEntity.setRequirements(requirement);
        return requestEntity;

    }

    public static class AlumniRequire extends BidVpRequirement{

    }


    public static BidVpEntity buildCredentialVp(){
        BidVpEntity credentialVp = new BidVpEntity();
        String jwsStr = "";//TODO
        BidVp.CredentialRequest credentialRequest = new BidVp.CredentialRequest();
        credentialRequest.setJws(jwsStr);
        credentialVp.setCredentialRequest(credentialRequest);
        List<BidVp.CredentialParse> parseList = new ArrayList<>();
        BidVp.CredentialParse credentialParse1 = new BidVp.CredentialParse();
        credentialParse1.setParseType(BidCredentialConstants.DIRECT);
        credentialParse1.setFormat(ParseFunEnum.BID.getCode());
        parseList.add(credentialParse1);
        BidVp.CredentialParse credentialParse2 = new BidVp.CredentialParse();
        credentialParse2.setParseType(BidCredentialConstants.DIRECT);
        credentialParse2.setFormat(ParseFunEnum.JWS.getCode());
        parseList.add(credentialParse2);
        credentialVp.setCredentialParse(parseList);
        JSONObject vc1 = new JSONObject();
        vc1.put("@id","did:bid:efJgt44mNDewKK1VEN454R17cjso3mSG");
        JSONObject vc2 = new JSONObject();
        vc2.put("jws",jwsStr);
        credentialVp.setVerifiableCredential(Arrays.asList(vc1,vc2));
        BidVp.Proof proof = new BidVp.Proof();
        proof.setComposeType(BidCredentialConstants.DIRECT);
        credentialVp.setProofs(proof);
        return credentialVp;

    }


    public static BidPvEntity buildCredentialPassEntity(){
        BidPvEntity credentialPass = new BidPvEntity();
        String jwsStr = "";//TODO
        BidPvEntity.CredentialRequest credentialRequest = new BidPvEntity.CredentialRequest();
        credentialRequest.setJws(jwsStr);
        credentialPass.setCredentialRequest(credentialRequest);
        credentialPass.setCreate("2010-01-01T19:23:24Z");
        credentialPass.setIssuer("did:bid:efJgt44mNDewKK1VEN454R17cjso3mSG");

        return credentialPass;

    }

}
