package org.bif.test;


import cn.caict.encryption.key.PrivateKey;
import cn.caict.encryption.key.PublicKey;
import cn.caict.encryption.utils.sm2.SM2;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;

import org.bif.common.utils.Base64Util;
import org.bif.common.utils.Sm4Util;
import org.bif.entity.bidComm.BidCommVEEntity;
import org.bif.protocol.bidComm.BidCommPlaintext;
import org.bif.protocol.bidComm.BidCommSignature;
import org.bif.protocol.bidComm.Signature.SignObj;

import org.bif.protocol.enums.AlgorithmEnum;
import org.bif.protocol.enums.bidComm.PlaintextTypeEnum;


import java.nio.charset.StandardCharsets;
import java.util.*;


public class BidCommTest {



    public static  void main(String[] args) {
        initBidComm();
    }

    public static void initBidComm(){
        try {
            BidCommVEEntity veEntity = initBidCommVe();
            System.out.println("start parse -------------");
            parseBidCommVe(veEntity);
            //System.out.println(JSONObject.toJSONString(veEntity));
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String getSeqId(){

        return UUID.randomUUID().toString();
    }



    public static BidCommVEEntity initBidCommVe(){
         String plaintextType = PlaintextTypeEnum.BIDAUTH.getType();
        String plaintextId = getSeqId();
        String contentStr = "{\"name\":\"张三\",\"age\":\"18\"}";
        JSONObject plaintextContent = JSONObject.parseObject(contentStr);
        System.out.println("-----initBidCommVe plaintext str: " + plaintextContent.toString());
        List<SignObj> signObjList = new ArrayList<>();
        SignObj signObj = new SignObj();
        signObj.getHeader().setAlg(AlgorithmEnum.SM2.getCode());
        signObj.getHeader().setKid("did:bid:zfwwYEeDpiNo7f9aXN7uLA3FMbguSTNv#keys-1");
        BidCommPlaintext bidCommPlaintext = new BidCommPlaintext(plaintextType,plaintextId,plaintextContent);
        String payload = Base64Util.base64Encode(JSON.toJSONString(bidCommPlaintext));
        //sign
        PrivateKey privateKey = new PrivateKey("priSrroUh2EVHDsFZAYYXorKRmgm1qjkSxYPwex8EQJrpAwMqU");

        System.out.println("-----initBidCommVe payload str: " + payload);
        signObj.setSignature(Base64Util.base64Encode((PrivateKey.sign(payload.getBytes(StandardCharsets.UTF_8),privateKey.getEncPrivateKey()))));
        System.out.println("-----initBidCommVe signStr str: " + signObj.getSignature());
        signObjList.add(signObj);
        Map<String,String> receiveMap = new HashMap<>();
        receiveMap.put("did:bid:zfwwYEeDpiNo7f9aXN7uLA3FMbguSTNv#key-1",
                "b07a6604bd0e4d2850cf0b04c3c34f4af37dd6277303ef501cb511851c7e4cb3e08436cc842fff91aeaa539e897f1aadc8a8ebc2c12e3c22a781da4ea51e50cfbc847e40");
        return new BidCommVEEntity(bidCommPlaintext,signObjList,receiveMap);

    }

    public static void parseBidCommVe(BidCommVEEntity bidCommVE) throws Exception {
        try {
            System.out.println(bidCommVE.getTyp());
            System.out.println("+++++BidCommEncryption str: " +JSONObject.toJSONString(bidCommVE));
            PrivateKey privateKey = new PrivateKey("priSrroUh2EVHDsFZAYYXorKRmgm1qjkSxYPwex8EQJrpAwMqU");
            byte[] encKeyData = Base64Util.base64Decode(bidCommVE.getRecipients().get(0).getEncrypted_key());

            byte[] encKeyByte = SM2.decrypt(encKeyData, privateKey.getEncPrivateKey());

            String encKey = new String(encKeyByte);
            System.out.println("+++++encKey str: " +encKey);
            String signStr = Sm4Util.decryptEcb(encKey, bidCommVE.getCiphertext());
            System.out.println("+++++BidCommSignature str: " +signStr);
            BidCommSignature bidCommSignature = JSON.parseObject(signStr,BidCommSignature.class);
            String payload = bidCommSignature.getPayload();
            System.out.println("+++++payload str: " + payload);
            boolean bVerifySign  = PublicKey.verify(payload.getBytes(StandardCharsets.UTF_8),
                    Base64Util.base64Decode(bidCommSignature.getSignatures().get(0).getSignature()),
                    privateKey.getEncPublicKey());
            System.out.println("+++++bVerifySign ret: " + bVerifySign);
            BidCommPlaintext bidCommPlaintext = JSON.parseObject( Base64Util.base64Decode2String(payload),BidCommPlaintext.class);
            Object plaintext = bidCommPlaintext.getContent();
            System.out.println("+++++bidCommPlaintext str: " + JSONObject.toJSONString(bidCommPlaintext));
            System.out.println("+++++plaintext str: " + plaintext);

        }catch (Exception e){
            System.out.println(e.getMessage());
        }
    }

}
