package org.bif.protocol.enums.bidCredential;

public enum ProcessTypeEnum {
    VC("VerifiableCredential", "可信数字证书"),
    CR("credentialRequest", "资质验证请求"),
    VP("VerifiablePresentation", "可信数字声明"),
    PV("PresentationVerified", "验证声明结果"),
    ;

    private String type;
    private String desc;

    private ProcessTypeEnum(String type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
}
