package org.bif.protocol.bidCredential;


import com.alibaba.fastjson.annotation.JSONField;
import org.bif.protocol.constant.BidCredentialConstants;
import org.bif.protocol.enums.bidCredential.ProcessTypeEnum;


import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

//可信数字证书
public class BidCredential implements Serializable {
    /**
     {
     "@context": [
        "https://www.w3.org/2018/credentials/v1",
        "https://www.w3.org/2018/credentials/examples/v1"
     ],
     "id  ": "http://example.edu/credentials/1872",
     "bid": "did:bid:efJgt44mNDewKK1VEN454R17cjso3mSG",
     "type": [
        "VerifiableCredential",
        "AlumniCredential"
     ],
     "issuer": "did:bid:efJgt44mNDewKK1VEN454R17cjso3mSG",
     "issuanceDate": "2010-01-01T19:23:24Z",
     "templateId": "20100101T23Nedex",
     "validBefore": "2010-10-01T19:23:24Z ",
     "credentialSubject": {
        "id": "did:bid:efJgt44mNDewKK1VEN454R17cjso3mSG",
        "alumniOf": {
            "id": "did:bid:efJgt44mNDewKK1VEN454R17cjso3mSG",
            "name": [{
            "value": "Example University",
            "lang": "en"
            }]
        }
     },
     "revocationId": "20100101NN30d398"
     }
     */
    // **json-ld**标准格式，必须包含 "https://www.w3.org/2018/credentials/v1".
    @JSONField(name="@context")
    private List<String> context;
    //id: 证书发行方内唯一id，供验证方查询使用
    private String id;
    //type: 数组，证书所属类型，必须包含VerifiableCredential
    private List<String> type;
    //issuer: 证书发行者bid地址
    private String issuer;
    //issuanceDate: 证书发行日期
    private String issuanceDate;
    //模板id，证书扩展字段格式模板编号
    private String templateId;
    //validBefore: 证书有效期截止时间
    private String validBefore;
    //证书内容，包含一个必须字段id
    private Object credentialSubject;
    // 凭证撤销id,具体的实现待定
    private String revocationId;
    //parseType : 证书解析方式
    private String parseType;

    public BidCredential(String id){
        this.context = new ArrayList<>();
        this.context.add(BidCredentialConstants.CONTEXT);
        this.type = new ArrayList<>();
        this.type.add(ProcessTypeEnum.VC.getType());
        this.id = id;
    }

    public BidCredential(){
    }

    public List<String> getContext() {
        return context;
    }

    public void setContext(List<String> context) {
        this.context = context;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public List<String> getType() {
        return type;
    }

    public void setType(List<String> type) {
        this.type = type;
    }

    public void addType(String type) {
        this.type.add(type);
    }

    public String getIssuer() {
        return issuer;
    }

    public void setIssuer(String issuer) {
        this.issuer = issuer;
    }

    public String getIssuanceDate() {
        return issuanceDate;
    }

    public void setIssuanceDate(String issuanceDate) {
        this.issuanceDate = issuanceDate;
    }

    public String getTemplateId() {
        return templateId;
    }

    public void setTemplateId(String templateId) {
        this.templateId = templateId;
    }

    public String getValidBefore() {
        return validBefore;
    }

    public void setValidBefore(String validBefore) {
        this.validBefore = validBefore;
    }

    public Object getCredentialSubject() {
        return credentialSubject;
    }

    public void setCredentialSubject(Object credentialSubject) {
        this.credentialSubject = credentialSubject;
    }

    public String getRevocationId() {
        return revocationId;
    }

    public void setRevocationId(String revocationId) {
        this.revocationId = revocationId;
    }

    public String getParseType() {
        return parseType;
    }

    public void setParseType(String parseType) {
        this.parseType = parseType;
    }
}