package org.bif.protocol.bidComm;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.annotation.JSONField;
import org.bif.protocol.bidComm.Signature.SignObj;
import org.bif.protocol.enums.bidComm.TypEnum;

import java.util.List;

public class BidCommSignature extends BidComm{
        /**
         {
         "typ": "bidcomm-signed+json",
         "signatures": [{
                         "header": {
                         "alg": "SM2",
                         "kid": "did:bid:zf27zkk8D72F13HAzY1ECsK12VPUHxKZS#keys-1"
                },
                "signature": "FW33NnvOHV0Te…WNMgP2EVCQ",
         }],
         "payload": "eyJpZCI6IjEyMzQ1Njc4O…aXRzIHZhbHVlIn19"
         }
         */

        private String typ;
        //签名组
        private List<SignObj> signatures;
        //消息明文Base64编码后的封装
        private String payload;

        public BidCommSignature(String type,
                                List<SignObj> signatures,
                                String payload){
                this.typ = TypEnum.SIGN.getTyp();
                this.signatures = signatures;
                this.payload = payload;
        }

        public BidCommSignature(){
                this.typ = TypEnum.SIGN.getTyp();
        }

        public String getTyp() {
                return typ;
        }

        public void setTyp(String typ) {
                this.typ = typ;
        }

        public List<SignObj> getSignatures() {
                return signatures;
        }

        public void setSignatures(List<SignObj> signatures) {
                this.signatures = signatures;
        }

        public String getPayload() {
                return payload;
        }

        public void setPayload(String payload) {
                this.payload = payload;
        }
}