package org.bif.protocol.bidComm;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.annotation.JSONField;

import org.bif.protocol.bidComm.plaintext.PlaintextThread;
import org.bif.protocol.bidComm.plaintext.PlaintextTiming;
import org.bif.protocol.enums.bidComm.TypEnum;

import java.util.List;

public class BidCommPlaintext extends BidComm{
    /**
     {
         "@type": "bidcomm_application/1.0/bidauth"，
         "@id": "ace2b31a-8895-4547-8a54-1abf75aa1137"，
         "please_ack": ["did:bid:example_abc", "did:bid:example_efg"],
         "timing": {
             "created_time": "1637546400"，
             "expires_time": "1637719200"，
             "created_time_l10n": "2021-11-22T10:00:00Z"，
             "expires_time_l10n": "2021-11-24T10:00:00Z"
         },
         "thread": {
             "pthid": "ace2b31a-8895-4547-8a54-1abf75aa1137"，
             "thid": "852c7162-d4a2-45ba-9dcb-e0d37c1fa296",
             "sender_order": 3,
             "received_orders": {"did:bid:abcdef":1,"did:bid:ghijkl":11, "did:bid:mnopqr":-1}
         },
         "content": {
             "type": "bidauth_request"，
             "bid": "did:bid:efCB2YndSDRHrMF7mTbGVkpbatAdybKW",
             "publicKey": "b06566014b06ef94821e325e047a880b328aa9276060b97d6b148e16199ab1b1edff11"
         }
     }
     */
    //明文消息
    private String typ;
    //有效的消息类型URI
    @JSONField(name="@type")
    private String type;
    //唯一消息ID,建议使用UUID
    @JSONField(name="@id")
    private String id;
    //接收者的BID，字符串数组类型
    private List<String> please_ack;
    //被回复消息的@id
    private String ack;
    //时间标识符
    private PlaintextTiming timing;
    //线程标识符
    private PlaintextThread thread;
    //消息主体
    private Object content;

    //基本明文信息
    public BidCommPlaintext(){
        this.typ = TypEnum.PLAINTEXT.getTyp();
    }

    //明文信息
    public BidCommPlaintext(String type,
                            String id,
                            JSONObject content){
        this.typ = TypEnum.PLAINTEXT.getTyp();
        this.type = type;
        this.id = id;
        this.content = content;
    }





    public String getTyp() {
        return typ;
    }

    public void setTyp(String typ) {
        this.typ = typ;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public List<String> getPlease_ack() {
        return please_ack;
    }

    public void setPlease_ack(List<String> please_ack) {
        this.please_ack = please_ack;
    }

    public String getAck() {
        return ack;
    }

    public void setAck(String ack) {
        this.ack = ack;
    }

    public PlaintextTiming getTiming() {
        return timing;
    }

    public void setTiming(PlaintextTiming timing) {
        this.timing = timing;
    }

    public PlaintextThread getThread() {
        return thread;
    }

    public void setThread(PlaintextThread thread) {
        this.thread = thread;
    }

    public Object getContent() {
        return content;
    }

    public void setContent(Object content) {
        this.content = content;
    }
}