package org.bif.protocol.bid;

import com.alibaba.fastjson.annotation.JSONField;
import org.bif.common.utils.*;
import org.bif.protocol.bid.attribute.AttributeCredential;
import org.bif.protocol.bid.service.ServiceBase;
import org.springframework.beans.BeanUtils;

import java.util.List;

public class BidProtocol {

    @JSONField(name="@context")
    private List<String> context;
    private String id;
    private String version;
    private String created;
    private String updated;
    private List<PublicKeyEntity> publicKey;
    private List<Object> authentication;
    private List<AlsoKnownAsEntity> alsoKnownAs;
    private Extension extension;
    private Proof proof;
    private List<Object> service;

    public List<String> getContext() {
        return context;
    }

    public void setContext(List<String> context) {
        this.context = context;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }


    public String getVersion() {
        return version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getCreated() {
        return created;
    }

    public void setCreated(String created) {
        this.created = created;
    }

    public String getUpdated() {
        return updated;
    }

    public void setUpdated(String updated) {
        this.updated = updated;
    }

    public List<PublicKeyEntity> getPublicKey() {
        return publicKey;
    }

    public void setPublicKey(List<PublicKeyEntity> publicKey) {
        this.publicKey = publicKey;
    }

    public List<Object> getAuthentication() {
        return authentication;
    }

    public void setAuthentication(List<Object> authentication) {
        this.authentication = authentication;
    }

    public List<AlsoKnownAsEntity> getAlsoKnownAs() {
        return alsoKnownAs;
    }

    public void setAlsoKnownAs(List<AlsoKnownAsEntity> alsoKnownAs) {
        this.alsoKnownAs = alsoKnownAs;
    }

    public Extension getExtension() {
        return extension;
    }

    public void setExtension(Extension extension) {
        this.extension = extension;
    }

    public Proof getProof() {
        return proof;
    }

    public void setProof(Proof proof) {
        this.proof = proof;
    }

    public List<Object> getService() {
        return service;
    }

    public void setService(List<Object> service) {
        this.service = service;
    }

    public static class AlsoKnownAsEntity {
        /**
         {
         "type": 104,
         "id": "88.111.1/abc"
         }
         */
        private String id;
        private Integer type;


        public String getId() {
            return id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public Integer getType() {
            return type;
        }

        public void setType(Integer type) {
            this.type = type;
        }
    }


    public static class PublicKeyEntity {
        /**
         {
         "id": "did:bid:ZUZQkYXw6f87t3JkHCr2MauQAzYB2zM1s#keys-1",
         "type": "Ed25519",
         "controller": "did:bid:efnVUgqQFfYeu97ABf6sGm3WFtVXHZB2",
         "publicKeyHex": "02b97c30de767f084ce3080168ee293053ba33b235d7116a3263d29f1450936b71"
         }
         */
        private String id;
        private String type;
        private String controller;
        private String publicKeyHex;

        public String getId() {
            return id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getType() {
            return type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getController() {
            return controller;
        }

        public void setController(String controller) {
            this.controller = controller;
        }

        public String getPublicKeyHex() {
            return publicKeyHex;
        }

        public void setPublicKeyHex(String publicKeyHex) {
            this.publicKeyHex = publicKeyHex;
        }
    }

    public static class Extension {
        /**
         "recovery": ["did:bid:efnVUgqQFfYeu97ABf6sGm3WFtVXHZB2#key-2"],
         "ttl": 86400,
         "delegateSign ": {
         "signer": "did:bid:efJgt44mNDewKK1VEN454R17cjso3mSG#key-1",
         "signatureValue": "eyJhbGciOiJSUzI1NiIsImI2NCI6ZmFsc2UsImNyaXQiOlsiYjY0Il19"
         },
         "type": 10001,
         "attributes": [{
         "key": "contract",
         "desc": "智能合约地址",
         "encrypt": "false",
         "type": "text",
         "value": "did:bid:efJgt44mNDewKK1VEN454R17cjso3mSG"
         }]
         "acsns": ["abcd"],
         */
        private List<String> recovery;
        private Long ttl;
        private DelegateSign delegateSign;
        private Integer type;
        private List<Object> attributes;
        private List<String> acsns;
        private List<VerifiableCredential> verifiableCredentials;

        public List<String> getAcsns() {
            return acsns;
        }

        public void setAcsns(List<String> acsns) {
            this.acsns = acsns;
        }

        public List<String> getRecovery() {
            return recovery;
        }

        public void setRecovery(List<String> recovery) {
            this.recovery = recovery;
        }

        public Long getTtl() {
            return ttl;
        }

        public void setTtl(Long ttl) {
            this.ttl = ttl;
        }

        public DelegateSign getDelegateSign() {
            return delegateSign;
        }

        public void setDelegateSign(DelegateSign delegateSign) {
            this.delegateSign = delegateSign;
        }

        public Integer getType() {
            return type;
        }

        public void setType(Integer type) {
            this.type = type;
        }

        public List<Object> getAttributes() {
            return attributes;
        }

        public void setAttributes(List<Object> attributes) {
            this.attributes = attributes;
        }


        public List<VerifiableCredential> getVerifiableCredentials() {
            return verifiableCredentials;
        }

        public void setVerifiableCredentials(List<VerifiableCredential> verifiableCredentials) {
            this.verifiableCredentials = verifiableCredentials;
        }
    }

    public static class DelegateSign {
        /**
         {
         "signer": "did:bid:efJgt44mNDewKK1VEN454R17cjso3mSG#key-1",
         "signatureValue": "eyJhbGciOiJSUzI1NiIsImI2NCI6ZmFsc2UsImNyaXQiOlsiYjY0Il19"
         }
         */
        private String signer;
        private String signatureValue;

        public String getSigner() {
            return signer;
        }

        public void setSigner(String signer) {
            this.signer = signer;
        }


        public String getSignatureValue() {
            return signatureValue;
        }

        public void setSignatureValue(String signatureValue) {
            this.signatureValue = signatureValue;
        }
    }

    public static class VerifiableCredential {

        private Integer type;
        private String id;

        public Integer getType() {
            return type;
        }

        public void setType(Integer type) {
            this.type = type;
        }

        public String getId() {
            return id;
        }

        public void setId(String id) {
            this.id = id;
        }
    }

    public static class AcsnEntity {

        private String acsn;
        private String acsnAddress;

        public String getAcsn() {
            return acsn;
        }

        public void setAcsn(String acsn) {
            this.acsn = acsn;
        }

        public String getAcsnAddress() {
            return acsnAddress;
        }

        public void setAcsnAddress(String acsnAddress) {
            this.acsnAddress = acsnAddress;
        }
    }




}
