package org.bif.entity.bidComm;



import com.alibaba.fastjson.JSONObject;
import org.bif.common.utils.Base64Util;
import org.bif.exception.BidCommException;

import org.bif.protocol.bidComm.BidCommPlaintext;
import org.bif.protocol.bidComm.BidCommSignature;
import org.bif.protocol.bidComm.Signature.SignObj;

import java.util.List;


//Verifiable    ---  V  可验证公有信息
public class BidCommVEntity extends BidCommSignature {


    /*
    *BidCommPlaintext   消息明文
    *signObjList        每个签名SignObj
    * */
    public BidCommVEntity(BidCommPlaintext bidCommPlaintext,
                          List<SignObj> signObjList){
        super();
        initBidCommSignature(bidCommPlaintext,signObjList);
    }

    public BidCommVEntity(){
        super();
    }

    private void initBidCommSignature(BidCommPlaintext bidCommPlaintext, List<SignObj> signObjList){
        try{
            System.out.println("-----bidCommPlaintext str: " + JSONObject.toJSONString(bidCommPlaintext));

            String payload = Base64Util.base64Encode(JSONObject.toJSONString(bidCommPlaintext));
            System.out.println("-----initBidCommSignature -bidCommPlaintext payload str: " + payload);
            this.setSignatures(signObjList);
            this.setPayload(payload);

        }catch (Exception e){
            throw new BidCommException("initBidCommEncryption error");
        }

    }




}
