package org.bif.entity.bidAuth;



import org.bif.protocol.bidComm.BidCommPlaintext;
import org.bif.protocol.enums.bidAuth.AuthTypeEnum;
import org.bif.protocol.enums.bidComm.PlaintextTypeEnum;

//   请求信息
public class BidAuthResultEntity extends BidCommPlaintext {


    public BidAuthResultEntity(String id,
                               String bid,
                               boolean result){
        super();
        BidAuthResultContent content = new BidAuthResultContent(bid,result);
        this.setType(PlaintextTypeEnum.BIDAUTH.getType());
        this.setId(id);
        this.setContent(content);
    }

    public BidAuthResultEntity(){
        super();
    }


    //   CONTENT内容
    public static class BidAuthResultContent   {

        private String type;
        private String bid;
        private boolean result;

        public BidAuthResultContent(){

        }

        public BidAuthResultContent(String bid, boolean result){
            this.type = AuthTypeEnum.RESULT.getType();
            this.bid = bid;
            this.result = result;
        }

        public String getType() {
            return type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getBid() {
            return bid;
        }

        public void setBid(String bid) {
            this.bid = bid;
        }

        public boolean isResult() {
            return result;
        }

        public void setResult(boolean result) {
            this.result = result;
        }
    }


}
