package org.bif.entity.bidAuth;



import org.bif.protocol.bidComm.BidCommPlaintext;
import org.bif.protocol.enums.bidAuth.AuthTypeEnum;
import org.bif.protocol.enums.bidComm.PlaintextTypeEnum;

//   挑战信息
public class BidAuthChallengeEntity extends BidCommPlaintext {


    public BidAuthChallengeEntity(String id,
                                  String nonce){
        super();
        BidAuthChallengeContent content = new BidAuthChallengeContent(nonce);
        this.setType(PlaintextTypeEnum.BIDAUTH.getType());
        this.setId(id);
        this.setContent(content);
    }

    public BidAuthChallengeEntity(){
        super();
    }

    //   CONTENT内容
    public static class BidAuthChallengeContent  {

        private String type;
        private String nonce;

        public BidAuthChallengeContent(){

        }

        public BidAuthChallengeContent( String nonce){
            this.type = AuthTypeEnum.CHALLENGE.getType();
            this.nonce = nonce;
        }

        public String getType() {
            return type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getNonce() {
            return nonce;
        }

        public void setNonce(String nonce) {
            this.nonce = nonce;
        }
    }


}
