package org.bif.entity;




import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import org.bif.protocol.bid.BidProtocol;
import org.bif.protocol.bid.Proof;
import org.bif.protocol.bid.attribute.AttributeBase;
import org.bif.protocol.bid.attribute.AttributeCommon;
import org.bif.protocol.bid.attribute.AttributeCredential;
import org.bif.protocol.bid.service.ServiceBase;
import org.bif.protocol.bid.service.ServiceCommon;
import org.bif.protocol.bid.service.ServiceSubResolve;
import org.bif.protocol.enums.bid.AttributeTypeEnum;
import org.bif.protocol.enums.bid.ResolveServerTypeEnum;
import org.bif.protocol.enums.bid.ServiceTypeEnum;

import java.text.SimpleDateFormat;
import java.util.*;
import java.util.concurrent.CopyOnWriteArrayList;

import static org.bif.protocol.constant.BidProtocolConstants.*;

public class BIDDocumentEntity {

    private BidProtocol bidProtocol;

    public BidProtocol getBidProtocol() {
        return bidProtocol;
    }

    public void setBidProtocol(BidProtocol bidProtocol) {
        this.bidProtocol = bidProtocol;
    }



    public void setUpdateTime(String updateTime){
        bidProtocol.setUpdated(updateTime);
    }

    public void setCreateTime(String createTime){
        bidProtocol.setCreated(createTime);
    }

    public List<BidProtocol.PublicKeyEntity> getPublicKeyList(){
        return bidProtocol.getPublicKey();
    }

    public List<Object> getAuthentication(){
        return bidProtocol.getAuthentication();
    }

    public List<Object> getServiceList(){
        return bidProtocol.getService();
    }

    public BidProtocol.Extension getExtension(){
        return bidProtocol.getExtension();
    }

    public List<Object> getAttributeList(){
        return bidProtocol.getExtension().getAttributes();
    }

    public List<BidProtocol.AlsoKnownAsEntity> getAlsoKnownAsList(){
        return bidProtocol.getAlsoKnownAs();
    }

    public List<String> getRecovery(){
        return bidProtocol.getExtension().getRecovery();
    }

    public Long getTtl(){
        return bidProtocol.getExtension().getTtl();
    }

    private void initBIDDocumentEntity(String bid){
        bidProtocol =  new BidProtocol();
        bidProtocol.setContext(Arrays.asList(CONTEXT));
        bidProtocol.setVersion(VERSION);
        bidProtocol.setId(bid);

        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        bidProtocol.setCreated(dateFormat.format(new Date()));
        bidProtocol.setUpdated(dateFormat.format(new Date()));
        bidProtocol.setExtension(initExtension());
    }

    private BidProtocol.Extension initExtension(){
        BidProtocol.Extension extension = new BidProtocol.Extension();
        extension.setTtl(TTL);
        extension.setType(AttributeTypeEnum.UNKNOWN.getCode());
        return extension;
    }

    public void setProof(String creator, String signatureValue){
        Proof proof = new Proof();
        proof.setCreator(creator);
        proof.setSignatureValue(signatureValue);
        bidProtocol.setProof(proof);
    }


    public void addPublicKey(String id, String type, String controller,String publicKeyHex){
        List<BidProtocol.PublicKeyEntity> publicKeyList = bidProtocol.getPublicKey();
        if(null == publicKeyList){
            publicKeyList = new ArrayList<>();
        }
        BidProtocol.PublicKeyEntity publicKey = new BidProtocol.PublicKeyEntity();
        publicKey.setId(id);
        publicKey.setType(type);
        publicKey.setController(controller);
        publicKey.setPublicKeyHex(publicKeyHex);
        publicKeyList.add(publicKey);
        bidProtocol.setPublicKey(publicKeyList);
    }

    public void addAuthentication(String id){
        if(null == bidProtocol.getAuthentication()){
            List<Object> list = new ArrayList<>();
            bidProtocol.setAuthentication(list);
        }
        bidProtocol.getAuthentication().add(id);
    }

    public void addService( String id, String type, String endpoint){
        if(null == bidProtocol.getService()){
            List<Object> serviceEntity = new ArrayList<>();
            bidProtocol.setService(serviceEntity);
        }
        ServiceCommon service = new ServiceCommon();
        service.setId(id);
        service.setType(type);
        service.setServiceEndpoint(endpoint);
        bidProtocol.getService().add(service);
    }

    public void addDidResolveService(String id,String endpoint){
        if(null == bidProtocol.getService()){
            List<Object> serviceEntity = new ArrayList<>();
            bidProtocol.setService(serviceEntity);
        }
        ServiceCommon service = new ServiceCommon();
        //service.setId(String.format("%s#resolver",bidProtocol.getId()));
        service.setId(id);
        service.setType(ServiceTypeEnum.SERVICE_RESOLVER.getType());
        service.setServiceEndpoint(endpoint);
        bidProtocol.getService().add(service);
    }

    public void deleteService(){
        if(null == bidProtocol.getService()){
            return;
        }
        bidProtocol.setService(null);
    }

    public void deleteService(String serviceType){
        if(null == bidProtocol.getService()){
            return;
        }
        CopyOnWriteArrayList<Object> cowList = new CopyOnWriteArrayList<>(bidProtocol.getService());
        for(Object item : cowList){
            ServiceBase serviceBase = JSONObject.parseObject(JSON.toJSONString(item),ServiceBase.class);
            if(serviceBase.getType().equals(serviceType)){
                cowList.remove(item);
            }
        }
        bidProtocol.setService(cowList);
    }

    public void addDidSubResolveService(String id,String version,Integer protocolType,
                                        String endpoint,Integer port){
        if(null == bidProtocol.getService()){
            List<Object> serviceEntity = new ArrayList<>();
            bidProtocol.setService(serviceEntity);
        }
        ServiceSubResolve service = new ServiceSubResolve();
        //service.setId(String.format("%s#subResolver",bidProtocol.getId()));
        service.setId(id);
        service.setType(ServiceTypeEnum.SERVICE_SUB_RESOLVER.getType());
        service.setVersion(version);
        service.setProtocol(protocolType);
        service.setServerType(ResolveServerTypeEnum.IP.getCode());
        service.setServiceEndpoint(endpoint);
        service.setPort(port);
        bidProtocol.getService().add(service);
    }

    public void addDidSubResolveService(String id,String version,Integer protocolType,String url){
        if(null == bidProtocol.getService()){
            List<Object> serviceEntity = new ArrayList<>();
            bidProtocol.setService(serviceEntity);
        }
        ServiceSubResolve service = new ServiceSubResolve();
        //service.setId(String.format("%s#subResolver",bidProtocol.getId()));
        service.setId(id);
        service.setType(ServiceTypeEnum.SERVICE_SUB_RESOLVER.getType());
        service.setVersion(version);
        service.setProtocol(protocolType);
        service.setServerType(ResolveServerTypeEnum.URL.getCode());
        service.setServiceEndpoint(url);
        bidProtocol.getService().add(service);
    }

    public void addDidDecryptService(String id,String endpoint){
        if(null == bidProtocol.getService()){
            List<Object> serviceEntity = new ArrayList<>();
            bidProtocol.setService(serviceEntity);
        }
        ServiceCommon service = new ServiceCommon();
        //service.setId(String.format("%s#decrypt",bidProtocol.getId()));
        service.setId(id);
        service.setType(ServiceTypeEnum.SERVICE_DECRYPT.getType());
        service.setServiceEndpoint(endpoint);
        bidProtocol.getService().add(service);
    }

    public void addDidRevocationService(String id,String endpoint){
        if(null == bidProtocol.getService()){
            List<Object> serviceEntity = new ArrayList<>();
            bidProtocol.setService(serviceEntity);
        }
        ServiceCommon service = new ServiceCommon();
        //service.setId(String.format("%s#revocation",bidProtocol.getId()));
        service.setId(id);
        service.setType(ServiceTypeEnum.SERVICE_REVOCATION.getType());
        service.setServiceEndpoint(endpoint);
        bidProtocol.getService().add(service);
    }

    public void addDidStorageService(String id,String endpoint){
        if(null == bidProtocol.getService()){
            List<Object> serviceEntity = new ArrayList<>();
            bidProtocol.setService(serviceEntity);
        }
        ServiceCommon service = new ServiceCommon();
        //service.setId(String.format("%s#storage",bidProtocol.getId()));
        service.setId(id);
        service.setType(ServiceTypeEnum.SERVICE_STORAGE.getType());
        service.setServiceEndpoint(endpoint);
        bidProtocol.getService().add(service);
    }


    public void addExRecovery(String recovery){
        BidProtocol.Extension extension = bidProtocol.getExtension();
        if(null == extension.getRecovery()){
            List<String> recoveryList = new ArrayList<>();
            extension.setRecovery(recoveryList);
        }
        extension.getRecovery().add(recovery);
    }

    public void addExAcsn(String acsn){
        BidProtocol.Extension extension = bidProtocol.getExtension();
        if(null == extension.getAcsns() ){
            List<String> acsnsList = new ArrayList<>();
            extension.setAcsns(acsnsList);
        }
        extension.getAcsns().add(acsn);
    }

    public void addExDelegateSign(String signer, String signatureValue){
        BidProtocol.Extension extension = bidProtocol.getExtension();
        BidProtocol.DelegateSign delegateSign = new BidProtocol.DelegateSign();
        delegateSign.setSigner(signer);
        delegateSign.setSignatureValue(signatureValue);
        extension.setDelegateSign(delegateSign);
    }



    public void addExVerifiableCredential(BidProtocol.VerifiableCredential verifiableCredential){
        BidProtocol.Extension extension = bidProtocol.getExtension();
        if(null == extension.getVerifiableCredentials()){
            List<BidProtocol.VerifiableCredential> list = new ArrayList<>();
            extension.setVerifiableCredentials(list);
        }
        extension.getVerifiableCredentials().add(verifiableCredential);
    }

    public void addExVerifiableCredential(String id,Integer type){
        BidProtocol.Extension extension = bidProtocol.getExtension();
        if(null == extension.getVerifiableCredentials()){
            List<BidProtocol.VerifiableCredential> list = new ArrayList<>();
            extension.setVerifiableCredentials(list);
        }
        BidProtocol.VerifiableCredential verifiData = new BidProtocol.VerifiableCredential();
        verifiData.setId(id);
        verifiData.setType(type);
        extension.getVerifiableCredentials().add(verifiData);
    }

    public void setExType(Integer attributeType){
        bidProtocol.getExtension().setType(attributeType);
    }

    public void setExTtl(Long ttl){
        bidProtocol.getExtension().setTtl(ttl);
    }

    /**
    	 "id": "did:bid:efJgt44mNDewKK1VEN454R17cjso3mSG#userName",
        "key": "userName",
        "label": "用户名",
        "encrypt": "false",
        "type": "text",
        "value":"did:bid:efJgt44mNDewKK1VEN454R17cjso3mSG"
     */
    public void addExAttribute(String key,String desc,boolean encrypt,String type,String value){

        BidProtocol.Extension extension = bidProtocol.getExtension();
        if(null == extension.getAttributes()){
            List<Object> list = new ArrayList<>();
            extension.setAttributes(list);
        }
        AttributeCommon attribute = new AttributeCommon();
        attribute.setKey(key);
        attribute.setDesc(desc);
        attribute.setEncrypt(encrypt?1:0);
        attribute.setFormat(type);
        attribute.setValue(value);
        extension.getAttributes().add(attribute);


    }

    /**
     "issuer": "did:bid:efJgt44mNDewKK1VEN454R17cjso3mSG",
     "issuanceDate": "2021-01-20T12:01:20",
     "effectiveDate": "2021-01-20T12:01:20",
     "expirationDate": "2021-04-02T12:01:20",
     "revocationId": "did:bid:efJgt44mNDewKK1VEN454R17cjso3mSG#revocation",
     "templateId": "1231244",
     "credentialSubject": {
         "id": "did:bid:efJgt44mNDewKK1VEN454R17cjso3mSG",
         "type": 202,
         "description": “sdf”,
         "content": "agaretfgh",
         "name": "北京大学"
     },
     "proof": {
         "creator": "did:bid:efJgt44mNDewKK1VEN454R17cjso3mSG#key-1",
         "signatureValue": "eyJhbGciOiJSUzI1NiIsImI2NCI6ZmFsc2UsImNyaXQiOlsiYjY0Il19"
     }
     */
    public void addExCredentialAttribute(AttributeCredential attributeCredential){
        BidProtocol.Extension extension = bidProtocol.getExtension();
        if(null == extension.getAttributes()){
            List<Object> list = new ArrayList<>();
            extension.setAttributes(list);
        }
        extension.getAttributes().add(attributeCredential);
    }


    public void createBIDDocumentEntity(String bid){
        initBIDDocumentEntity(bid);
    }



}

