package org.bif.common.utils;

import cn.caict.encryption.key.PublicKey;
import cn.caict.encryption.utils.base.Base58;
import cn.caict.encryption.utils.hex.HexFormat;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;

import com.alibaba.fastjson.serializer.SerializerFeature;

import org.erdtman.jcs.JsonCanonicalizer;

import java.util.*;


public class SignUtil {

    private static byte[]  formatJcsDataByte(String jsonStr) throws Exception{
        JsonCanonicalizer jsonCanonicalizer = new JsonCanonicalizer(jsonStr);
        return jsonCanonicalizer.getEncodedUTF8();
    }

    private static String  formatJcsData(String jsonStr) throws Exception{
        JsonCanonicalizer jsonCanonicalizer = new JsonCanonicalizer(jsonStr);
        return jsonCanonicalizer.getEncodedString();
    }

    public static byte[]  formatWaitSignDataByte(String jsonStr) {
        try {
            return formatJcsDataByte(jsonStr);
        }catch (Exception e){
            System.out.print( e);
        }
        return null;
    }



    public static String  formatWaitSignData(String jsonStr) {
        try {
            return formatJcsData(jsonStr);
        }catch (Exception e){
            System.out.print( e);
        }
        return null;
    }

    public static String  formatSignData(byte[] signDataByte) {
        return Base58.encode(signDataByte);
    }

    public static String  formatSignData(String signData) {
        return Base58.encode(signData.getBytes());
    }

    public static boolean verifySign(String base58SignData,String msg,String publicKey){
        try {
            PublicKey publicKeyObj = new PublicKey(publicKey);
            byte[] decodeSignData = Base58.decode(base58SignData);
            return publicKeyObj.verify(msg.getBytes(),decodeSignData);
        }catch (Exception e){
            System.out.println(e.getMessage());
        }
        return false;
    }

    public static boolean verifySign(String base58SignData,byte[] msg,String publicKey){
        try {
            PublicKey publicKeyObj = new PublicKey(publicKey);
            byte[] decodeSignData = Base58.decode(base58SignData);
            return publicKeyObj.verify(msg,decodeSignData);
        }catch (Exception e){
            System.out.println(e.getMessage());
        }
        return false;
    }

}
