package org.bif.common.utils;

public class JwsUtil {

    public static String createJwsToken(String header,String payload,String signature) throws Exception{
        return String.format("%s.%s.%s", formatJwsStr(header), formatJwsStr(payload), Base64UrlUtil.base64Encode(signature));
    }

    public static String formatJwsToken(String header,String payload,String signature){
        return String.format("%s.%s.%s", header, payload, signature);
    }

    public static String formatJwsSignData(String header,String payload){
        return String.format("%s.%s", header, payload);
    }

    public static String formatJwsStr(String str) throws Exception{
        //序列化后，格式化
        return Base64UrlUtil.base64Encode(JcsUtil.formatJcsData(str));
    }



    private static String getPart(String token,int pos){
        String[] tokenArray = token.split("\\.");
        return tokenArray[pos];
    }

    public static String getHead(String token){
        return getPart(token,0);
    }

    public static String getPayload(String token){
        return getPart(token,1);
    }

    public static String getSign(String token){
        return getPart(token,2);
    }

    public static String parseHead(String token){
        String str = getHead(token);
        return Base64UrlUtil.base64UrlDecode2String(str);
    }

    public static String parsePayload(String token){
        String str = getPayload(token);
        return Base64UrlUtil.base64UrlDecode2String(str);
    }

    public static byte[] parseSign(String token){
        String str = getSign(token);
        return Base64UrlUtil.base64Decode(str);
    }
}