package cn.ac.caict.util;

import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.introspector.BeanAccess;
import org.yaml.snakeyaml.introspector.Property;
import org.yaml.snakeyaml.introspector.PropertyUtils;
import org.yaml.snakeyaml.representer.Representer;

import java.io.IOException;
import java.io.InputStream;


/**
 * 加载yaml配置到对象
 */
public class YamlLoader {



    public static Yaml yaml(){
        Representer representer = new Representer();
        representer.setPropertyUtils(new CamelCaseUseMinusPropertyUtils());
        representer.getPropertyUtils().setSkipMissingProperties(true);
        return new Yaml(representer);
    }

    /**
     * @throws IOException
     */
    public static <T> T yamlLoad(InputStream inputStream, Class<T> clazz) throws IOException {
        return yaml().loadAs(inputStream, clazz);

    }


    public static <T> T yamlLoad(String content, Class<T> clazz) throws IOException {
        return yaml().loadAs(content, clazz);

    }


    static class CamelCaseUseMinusPropertyUtils extends PropertyUtils {

        @Override
        public Property getProperty(Class<? extends Object> type, String name) {

            String newKey = camelCaseWithoutMinus(name);
            return super.getProperty(type, newKey, BeanAccess.FIELD);
        }

    }

    public static String camelCaseWithoutMinus(String key) {
        StringBuilder result = new StringBuilder();

        char[] cs = key.toCharArray();
        for (int i = 0; i < cs.length; i++) {
            if (cs[i] == '-') {
                result.append((char) (cs[i + 1] - 32));
                i++;
            } else {
                result.append(cs[i]);
            }
        }
         return result.toString();
    }


}
