package cn.ac.caict.util;

import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;

public class DateUtils {



    // 毫秒时间字符串
    public static final String TIME_MILLIS = "yyyy-MM-dd HH:mm:ss.SSS";




    /**
     * 获取某个格式日期
     */
    public static String now(String format) {

        return DateTime.now()
                .toString(format);
    }


    /**
     * 获取两个时间差的毫秒数
     */
    public static long betweenMillis(DateTime startTime, DateTime endTime) {
        if (startTime == null || endTime == null) {
            return 0;
        }
        return endTime.getMillis() - startTime.getMillis();
    }


    public static long betweenMillis(String startTime, String endTime) {
        if (startTime == null || endTime == null) {
            return 0;
        }
        DateTime s1 = DateTime.parse(startTime, DateTimeFormat.forPattern(TIME_MILLIS));
        DateTime s0 = DateTime.parse(endTime, DateTimeFormat.forPattern(TIME_MILLIS));
        return Math.abs(s0.getMillis() - s1.getMillis());
    }


}
