package cn.ac.caict.net.http.httpcomponents;

import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManagerBuilder;
import org.apache.hc.client5.http.ssl.SSLConnectionSocketFactory;
import org.apache.hc.client5.http.ssl.SSLConnectionSocketFactoryBuilder;
import org.apache.hc.core5.ssl.SSLContexts;
import org.apache.hc.core5.util.TimeValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.net.ssl.SSLContext;

public class DefaultExecutor {

    private static final Logger logger = LoggerFactory.getLogger(DefaultExecutor.class);
    final static CloseableHttpClient CLIENT;

    static {
        SSLContext sslcontext = null;
        try {
            sslcontext = SSLContexts.custom()
                    .loadTrustMaterial((chain, authType) -> {
                        //final X509Certificate cert = chain[0];
                        return true;
                    }).build();
        } catch (Exception e) {
            logger.error(e.getMessage(),e);
        }

        SSLConnectionSocketFactory sslSocketFactory = SSLConnectionSocketFactoryBuilder.create()
                .setSslContext(sslcontext)
                .build();


        CLIENT = HttpClientBuilder.create()
                .setConnectionManager(PoolingHttpClientConnectionManagerBuilder.create()
                        .useSystemProperties()
                        .setMaxConnPerRoute(100)
                        .setMaxConnTotal(200)
                        .setValidateAfterInactivity(TimeValue.ofSeconds(10))

                        //SSL 证书
                        .setSSLSocketFactory(sslSocketFactory)
                        .build())

                .useSystemProperties()
                .evictExpiredConnections()
                .evictIdleConnections(TimeValue.ofMinutes(1))
                .build();


    }
}
