package cn.ac.caict.net.http;

import com.google.common.base.Joiner;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;

public interface HttpClient {


    default HttpResponseEntity get(String url, Map<String, String> headers, Charset charset, int connectTimeout, int socketTimeout) {
        return null;
    }

    default HttpResponseEntity get(String url, Map<String, String> params, Map<String, String> headers, Charset charset, int connectTimeout, int socketTimeout) {
        String queryString = "";
        if (params != null) {
            final Map<String, String> queryParams = new HashMap<>();
            params.forEach((k, v) -> {
                try {
                    queryParams.put(URLEncoder.encode(k, charset.name()), URLEncoder.encode(k, charset.name()));
                } catch (UnsupportedEncodingException e) {
                }
            });
            queryString = "?" + Joiner.on("&").useForNull("").withKeyValueSeparator("=").join(queryParams);
        }
        return get(url + queryString, headers, charset, connectTimeout, socketTimeout);
    }


    /**
     * Content-Type: application/json
     *
     * @param url            : url 地址
     * @param content        : 请求内容
     * @param headers        : 请求header
     * @param charset        : 编码
     * @param connectTimeout : 链接超时时间
     * @param socketTimeout  : 读写数据超时时间
     * @return : 返回信息
     */
    default HttpResponseEntity post(String url, String content, Map<String, String> headers, Charset charset, int connectTimeout, int socketTimeout) {
        return null;
    }


    default HttpResponseEntity postForm(String url, Map<String, String> params, Map<String, String> headers, Charset charset, int connectTimeout, int socketTimeout) {
        return null;
    }


}
