package cn.ac.caict.entity;

/**
 * 相应信息
 */
public class ServicesResponseEntity{


    /**
     * 200 表示服务成功
     *
     */
    private int status;
    /**
     * 非200的原因
     */
    private String reason;

    /**
     * 错误编码
     */
    private String errorCode;

    /**
     * 基于请求，随机生成新的加密key
     */
    private String cipherKey;

    /**
     * 服务结果
     */
    private String serviceResult;

    /**
     * 客户端请求 - ID
     */
    private String clientTraceId;
    /**
     * 服务端 - 响应ID
     */
    private String serverTraceId;


    // 服务驱动调用开始时间
    private String requestTime;
    private String responseTime;

    /**
     * 服务结果
     */
    private String cipherData;
    private String plainData;

    /**
     * SHA256WithRSA（serverTraceId  + clientTraceId  + plain(cipherData) ）
     * SM3WITHSM2
     * | - 私钥签名
     * | - 公钥签名
     */
    private String sign;

    public int getStatus() {
        return status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public String getReason() {
        return reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public String getServerTraceId() {
        return serverTraceId;
    }

    public void setServerTraceId(String serverTraceId) {
        this.serverTraceId = serverTraceId;
    }

    public String getClientTraceId() {
        return clientTraceId;
    }

    public void setClientTraceId(String clientTraceId) {
        this.clientTraceId = clientTraceId;
    }

    public String getCipherData() {
        return cipherData;
    }

    public void setCipherData(String cipherData) {
        this.cipherData = cipherData;
    }

    public String getServiceResult() {
        return serviceResult;
    }

    public void setServiceResult(String serviceResult) {
        this.serviceResult = serviceResult;
    }

    public String getCipherKey() {
        return cipherKey;
    }

    public void setCipherKey(String cipherKey) {
        this.cipherKey = cipherKey;
    }

    public String getRequestTime() {
        return requestTime;
    }

    public void setRequestTime(String requestTime) {
        this.requestTime = requestTime;
    }

    public String getResponseTime() {
        return responseTime;
    }

    public void setResponseTime(String responseTime) {
        this.responseTime = responseTime;
    }

    public String getSign() {
        return sign;
    }

    public void setSign(String sign) {
        this.sign = sign;
    }

    public String getErrorCode() {
        return errorCode;
    }

    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    public String getPlainData() {
        return plainData;
    }

    public void setPlainData(String plainData) {
        this.plainData = plainData;
    }
}
