package cn.ac.caict.entity;

public interface ServicesRequest<T> {

    /**
     * 客户定义唯一id
     * 参数类型 : Varchar
     *
     * 参数长度 : 12 ~ 100
     */
    String getClientTraceId();

    /**
     * 客户接口访问账号
     * 参数类型 : Varchar
     * 参数长度 : 100
     */
    String getAccessKey();

    default String getServiceCode(){
        return null;
    };

    /**
     * 经过rsa加密后的秘钥
     */
    String getCipherKey();

    String getKeyAlg();
    String getDataAlg();

    String getKeyVersion();

    long getTimestamp();


    String getSign();

    String getCipherData();

    T getData();



}
