package cn.ac.caict.constants;


/**
 * 服务状态码
 * 参考 http 状态码
 *
 * @see <a href="https://www.iana.org/assignments/http-status-codes">HTTP Status Code Registry</a>
 * @author pony
 */
public enum ServicesStatus {
    /**
     * 服务处理成功
     */
    OK(200, "OK"),

    /**
     * 请求参数 - 格式校验失败
     *  %s : 具体校验未通过的参数名
     */
    BAD_REQUEST(400, "Bad Request , (%s)"),


    /**
     * 无权限访问
     *  %s : 无权限访问的原因
     */
    FORBIDDEN(403, "Forbidden, (%s)"),

    /**
     * 服务异常 - 重新尝试
     */
    SERVICE_EXCEPTION(521, "Service Exception");


    private final int value;

    private final String reasonPhrase;


    ServicesStatus(int value, String reasonPhrase) {
        this.value = value;
        this.reasonPhrase = reasonPhrase;
    }


    public int value() {
        return this.value;
    }

    public static boolean isSuccessful(int status) {
        return status == OK.value;
    }


}
