package cn.ac.caict.codec.text;

import cn.ac.caict.exception.CaictJsonException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;

public class JsonCodec<T> implements TextCodec<T, String> {

    private static final ObjectMapper objectMapper = new ObjectMapper();

    @Override
    public String encode(T obj) {
        try {
            return objectMapper.writeValueAsString(obj);
        } catch (JsonProcessingException e) {
            throw new CaictJsonException(e.getMessage(), e);
        }
    }

    @Override
    public T decode(String json) {
        try {
            return objectMapper.readValue(
                    json,
                    new TypeReference<T>() {
                    }
            );
        } catch (JsonProcessingException e) {
            throw new CaictJsonException(e.getMessage(), e);
        }
    }





    public static <T> String toJson(T obj){
        try {
            return objectMapper.writeValueAsString(obj);
        } catch (JsonProcessingException e) {
            throw new CaictJsonException(e.getMessage(), e);
        }
    }


    public static <T> String toJsonPretty(T obj){
        try {
            return objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString(obj);
        } catch (JsonProcessingException e) {
            throw new CaictJsonException(e.getMessage(), e);
        }
    }

    public static <T> T readValue(String json, Class<T> clazz) {
        try {
            return objectMapper.readValue(json, clazz);
        } catch (JsonProcessingException e) {
            throw new CaictJsonException(e.getMessage(), e);
        }
    }

    public static <T> T readValueAsType(String json) {
        try {
            return objectMapper.readValue(
                    json,
                    new TypeReference<T>() {
                    }
            );
        } catch (JsonProcessingException e) {
            throw new CaictJsonException(e.getMessage(), e);
        }
    }
}
