package cn.ac.caict.codec.text;

import org.bouncycastle.util.encoders.Hex;

import java.util.function.Function;

/**
 * @author pony
 */
public class HexCodec implements TextCodec<byte[],String> {


    private final Function<byte[],String> encoder;
    private final Function<String,byte[]> decoder;

    public HexCodec() {
        encoder = Hex::toHexString;
        decoder = Hex::decode;

    }

    public HexCodec(Function<byte[], String> encoder, Function<String, byte[]> decoder) {
        this.encoder = encoder;
        this.decoder = decoder;
    }

    @Override
    public String encode(byte[] hexByte) {
        return Hex.toHexString(hexByte);
    }

    @Override
    public byte[] decode(String hex) {
        return Hex.decode(hex);
    }

}