package cn.ac.caict.codec.text;

import java.util.Base64;
import java.util.function.Function;


/**
 * base64 编码 解码处理
 */
public class Base64Codec implements TextCodec<byte[],String> {
    private final Function<byte[],String> encoder;
    private final Function<String,byte[]> decoder;

    public Base64Codec() {
        encoder = Base64.getMimeEncoder()::encodeToString;
        decoder = Base64.getMimeDecoder()::decode;

    }

    public Base64Codec(Function<byte[], String> encoder, Function<String, byte[]> decoder) {
        this.encoder = encoder;
        this.decoder = decoder;
    }

    @Override
    public String encode(byte[] obj) {
        return encoder.apply(obj);
    }

    @Override
    public byte[] decode(String obj) {
        return decoder.apply(obj);
    }
}
