package cn.ac.caict.codec.crypto.symmetric;

import cn.ac.caict.exception.CaictCryptoException;
import org.bouncycastle.crypto.CryptoException;

import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;

/**
 * @author pony
 */
public abstract class DefaultSymmetricCodec implements SymmetricCodec {
    protected String alg;
    protected String keyAlg;
    protected String provider;

    public DefaultSymmetricCodec(String alg, String keyAlg, String provider) {
        this.alg = alg;
        this.keyAlg = keyAlg;
        this.provider = provider;
    }

    @Override
    public byte[] randomKey() {
        try {
            return randomKey(128);
        } catch (NoSuchProviderException | NoSuchAlgorithmException e) {
            throw new CaictCryptoException(e.getMessage(), e);
        }
    }

    public String alg() {
        return alg;
    }

    public String keyAlg() {
        return keyAlg;
    }

    public String provider() {
        return provider;
    }
}
