package cn.ac.caict.codec.crypto.symmetric;

import cn.ac.caict.codec.crypto.DefaultProviderFactory;

/**
 * key size 16 byte
 *   AES的区块长度固定为128 比特,密钥长度则可以是128,192或256比特
 * @author pony
 */
public class DESCodec extends DefaultSymmetricCodec {
    private static final String KEY_ALG = "DES";
    private static final String ALG = "DES/ECB/PKCS5Padding";

    public DESCodec() {
        this(ALG,KEY_ALG);
    }

    public DESCodec(String alg, String keyAlg) {
        this(alg,keyAlg,DefaultProviderFactory.getDefaultProvider());
    }

    public DESCodec(String alg, String keyAlg, String provider) {
        super(alg,keyAlg,provider);
    }

}
