package cn.ac.caict.codec.crypto.symmetric;

import cn.ac.caict.codec.crypto.DefaultProviderFactory;

/**
 * key size 16 byte
 *   AES的区块长度固定为128 比特,密钥长度则可以是128,192或256比特
 *
 */
public class AESCodec extends DefaultSymmetricCodec {
    private static final String KEY_ALG = "AES";
    private static final String ALG = "AES/ECB/PKCS5Padding";

    public AESCodec() {
        this(ALG,KEY_ALG);
    }

    public AESCodec(String alg, String keyAlg) {

        this(alg,keyAlg,DefaultProviderFactory.getDefaultProvider());
    }

    public AESCodec(String alg, String keyAlg, String provider) {
        super(alg,keyAlg,provider);
    }

}
