package cn.ac.caict.codec.crypto.digest.macs;

import org.bouncycastle.crypto.Mac;
import org.bouncycastle.crypto.params.KeyParameter;

/**
 * @author pony
 */
public interface MacDigestCodec {

    Mac mac();

    default byte[]  encode(byte[] messages, byte[] key ) {
        Mac mac = mac();
        byte[] resBuf = new byte[mac.getMacSize()];
        mac.init(new KeyParameter(key));
        mac.update(messages, 0, messages.length);
        mac.doFinal(resBuf, 0);
        return resBuf;
    }

}