package cn.ac.caict.codec.crypto.digest;

import org.bouncycastle.crypto.Digest;

import java.util.Objects;

/**
 * @author pony
 */
public interface DigestCodec {

	Digest digest();

	default byte[] encode(byte[] src) {
		Objects.requireNonNull(src);
		Digest digest = digest();
		digest.update(src, 0, src.length);
		byte[] digestData = new byte[digest.getDigestSize()];
		digest.doFinal(digestData, 0);
 		return digestData;
	}

}