package cn.ac.caict.codec.crypto.asymmetric;

import java.security.*;

/**
 * 基于公钥私钥，进行签名处理
 * @author pony
 */
public interface SignatureCodec extends AsymmetricCodec {


    /**
     * 签名计算
     * @param data
     * @param privateKey
     * @return
     * @throws Exception
     */
    default byte[] sign(byte[] data, PrivateKey privateKey) throws Exception {
        final Signature signature = Signature.getInstance(signAlg(), provider());
        signature.initSign(privateKey);
        signature.update(data);
        return signature.sign();
    }


    /**
     * 验证签名
     */
    default boolean verify(byte[] data, byte[] signature, PublicKey publicKey) throws NoSuchProviderException, NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        final Signature sig = Signature.getInstance(signAlg(), provider());
        sig.initVerify(publicKey);
        sig.update(data);
        return sig.verify(signature);
    }

}
