package cn.ac.caict.codec.crypto.asymmetric;

import cn.ac.caict.codec.crypto.DefaultProviderFactory;

import javax.crypto.Cipher;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.security.PrivateKey;
import java.security.PublicKey;


/**
 * @author pony
 */
public abstract class DefaultAsymmetricCodec implements AsymmetricCodec{

    private String alg;
    private String keyAlg;
    private String provider;
    private String signAlg;

    public DefaultAsymmetricCodec() {
    }

    public DefaultAsymmetricCodec(String alg, String keyAlg, String signAlg) {
        this(alg, keyAlg, signAlg, DefaultProviderFactory.getDefaultProvider());
    }

    public DefaultAsymmetricCodec(String alg, String keyAlg, String signAlg, String provider) {
        this.alg = alg;
        this.keyAlg = keyAlg;
        this.signAlg = signAlg;
        this.provider = provider;
    }


    @Override
    public String alg() {
        return this.alg;
    }

    @Override
    public String keyAlg() {
        return this.keyAlg;
    }

    @Override
    public String provider() {
        return this.provider;
    }

    @Override
    public String signAlg() {

        return this.signAlg;
    }

}
