package cn.ac.caict.codec.crypto.asymmetric;

import cn.ac.caict.codec.text.Base64Codec;
import cn.ac.caict.codec.text.TextCodec;
import cn.ac.caict.exception.CaictCryptoException;


/**
 * @author pony
 */
public class AsymmetricPKCS8KeyWrapper {

    private static final String BEGIN_PUBLIC_KEY = "-----BEGIN PUBLIC KEY-----";
    private static final String END_PUBLIC_KEY = "-----END PUBLIC KEY-----";
    private static final String BEGIN_PRIVATE_KEY = "-----BEGIN PRIVATE KEY-----";
    private static final String END_PRIVATE_KEY = "-----END PRIVATE KEY-----";

    private static final String CR = "\n";
    private static final String LF = "\r";
    private static final String REPLACE = "";

    private static final String[] RM_CHARS = {BEGIN_PUBLIC_KEY,END_PUBLIC_KEY,BEGIN_PRIVATE_KEY,END_PRIVATE_KEY};

    public static int PUBLIC = 1;
    public static int PRIVATE = 2;

    private static final Base64Codec base64Codec = new Base64Codec();
    private static final PublicKeyCodec publicKeyCodec = new PublicKeyCodec();
    private static final PrivateKeyCodec privateKeyCodec = new PrivateKeyCodec();



    public static String encode(byte[] data,int type) {
        if(type == PRIVATE){
            return privateKeyCodec.encode(data);
        }else if(type == PUBLIC){
            return publicKeyCodec.encode(data);
        }
        throw new CaictCryptoException("Illegal key type.");
    }

    public static byte[] decode(String data,int type) {
        if(type == PRIVATE){
            return privateKeyCodec.decode(data);
        }else if(type == PUBLIC){
            return publicKeyCodec.decode(data);
        }
        throw new CaictCryptoException("Illegal key type.");
    }



    public static String removeWrapper(String key){
        for(String regex : RM_CHARS){
            key = key.replaceAll(regex,REPLACE);
        }
        return key;
    }


    public static class PublicKeyCodec implements TextCodec<byte[], String>{
        @Override
        public String encode(byte[] obj) {
            StringBuilder text = new StringBuilder();
            text.append(BEGIN_PUBLIC_KEY).append(CR);
            text.append(base64Codec.encode(obj));
            text.append(CR).append(END_PUBLIC_KEY);
            return text.toString();
        }

        @Override
        public byte[] decode(final String key) {
            return base64Codec.decode(removeWrapper(key));
        }
    }


    public static class PrivateKeyCodec implements TextCodec<byte[], String>{
        @Override
        public String encode(byte[] obj) {
            StringBuilder text = new StringBuilder();
            text.append(BEGIN_PRIVATE_KEY).append(CR);
            text.append(base64Codec.encode(obj));
            text.append(CR).append(END_PRIVATE_KEY);
            return text.toString();
        }

        @Override
        public byte[] decode(String key) {
            return base64Codec.decode(removeWrapper(key));
        }
    }
}
