package cn.ac.caict.codec.crypto.asymmetric;

import java.security.PrivateKey;
import java.security.PublicKey;

/**
 * 非对称秘钥加解密处理
 *
 * @author pony
 */
public interface AsymmetricCodec {


    /**
     * 加密算法
     */
    String alg();

    /**
     * key : 算法
     */
    String keyAlg();

    /**
     * cipher provider
     */
    String provider();

    /**
     * 签名算法
     */
    String signAlg();


    /**
     * 秘钥生成
     *
     * @return return this
     */
    AsymmetricKeyCodec keyCodec();

    /**
     * 秘钥签名
     * return this
     */
    SignatureCodec signatureCodec();




    byte[] encrypt(byte[] data, PublicKey publicKey) throws Exception ;


    byte[] decrypt(byte[] data, PrivateKey privateKey) throws Exception ;

}
