package cn.ac.caict.codec.crypto;

import cn.ac.caict.exception.CaictCryptoException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import java.security.Key;

/**
 * @author pony
 */
public class CipherFactory {

    private static final Logger log = LoggerFactory.getLogger(CipherFactory.class);

    public static Key toKey(byte[] key, String keyAlg) {
        return new SecretKeySpec(key, keyAlg);
    }

    /**
     * get cipher instance. Default SecureRandom
     *
     * @param provider    bc
     * @param alg         加解密算法(算法/工作模式/填充模式[补齐方式])
     * @param encryptMode Cipher.ENCRYPT_MODE or DECRYPT_MODE
     * @param key         toKey
     * @param iv          CBC模式需要填写
     * @return 返回cipher
     */
    public static Cipher getInstance(String provider, String alg, int encryptMode, Key key, byte[] iv) {
        try {
            Cipher cipher = Cipher.getInstance(alg,provider);
            if (iv != null) {
                IvParameterSpec ivParameterSpec = new IvParameterSpec(iv);
                cipher.init(encryptMode, key, ivParameterSpec);
            } else {
                cipher.init(encryptMode, key);
            }

            return cipher;
        } catch (Exception e) {
            log.error("bouncy-castle <{}> err. {} ", alg, e.getCause());
            log.error(e.getMessage(), e);
           throw new CaictCryptoException(e.getMessage(),e);
        }
    }

    public static Cipher getInstance(String keyAlg, String alg, int encryptMode, byte[] key, byte[] iv) {
        Key cipherKeySpec = toKey(key, keyAlg);
        return getInstance(keyAlg, alg, encryptMode, cipherKeySpec, iv);
    }

}
