/*
 * Decompiled with CFR 0.152.
 */
package cn.bitfactory.encryption.utils.sm2;

import cn.bitfactory.encryption.exception.EncException;
import cn.bitfactory.encryption.model.KeyMember;
import cn.bitfactory.encryption.utils.hash.SM3Digest;
import cn.bitfactory.encryption.utils.sm2.SM2KeyPair;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.Arrays;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.math.ec.ECPoint;

public class SM2 {
    private static BigInteger n = new BigInteger("FFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFF7203DF6B21C6052B53BBF40939D54123", 16);
    private static BigInteger p = new BigInteger("FFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000FFFFFFFFFFFFFFFF", 16);
    private static BigInteger a = new BigInteger("FFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000FFFFFFFFFFFFFFFC", 16);
    private static BigInteger b = new BigInteger("28E9FA9E9D9F5E344D5A9E4BCF6509A7F39789F515AB8F92DDBCBD414D940E93", 16);
    private static BigInteger gx = new BigInteger("32C4AE2C1F1981195F9904466A39C9948FE30BBFF2660BE1715A4589334C74C7", 16);
    private static BigInteger gy = new BigInteger("BC3736A2F4F6779C59BDCEE36B692153D0A9877CC62A474002DF32E52139F0A0", 16);
    private static ECDomainParameters ecc_bc_spec;
    private static int w;
    private static BigInteger _2w;
    private static final int DIGEST_LENGTH = 32;
    private static SM3Digest SM3;
    private static SecureRandom random;
    public static ECCurve.Fp curve;
    public static ECPoint G;

    private static BigInteger random(BigInteger max) {
        BigInteger r = new BigInteger(256, random);
        while (r.compareTo(max) >= 0) {
            r = new BigInteger(128, random);
        }
        return r;
    }

    private static boolean between(BigInteger param, BigInteger min, BigInteger max) {
        return param.compareTo(min) >= 0 && param.compareTo(max) < 0;
    }

    private boolean checkPublicKey(ECPoint publicKey) {
        if (!publicKey.isInfinity()) {
            BigInteger x = publicKey.getXCoord().toBigInteger();
            BigInteger y = publicKey.getYCoord().toBigInteger();
            if (SM2.between(x, new BigInteger("0"), p) && SM2.between(y, new BigInteger("0"), p)) {
                BigInteger xResult = x.pow(3).add(a.multiply(x)).add(b).mod(p);
                BigInteger yResult = y.pow(2).mod(p);
                if (yResult.equals(xResult) && publicKey.multiply(n).isInfinity()) {
                    return true;
                }
            }
        }
        return false;
    }

    public SM2KeyPair generateKeyPair() {
        BigInteger d = SM2.random(n.subtract(new BigInteger("1")));
        SM2KeyPair keyPair = new SM2KeyPair(G.multiply(d).normalize(), d);
        if (this.checkPublicKey(keyPair.getPublicKey())) {
            return keyPair;
        }
        return null;
    }

    public SM2() {
        ecc_bc_spec = new ECDomainParameters((ECCurve)curve, G, n);
    }

    private static byte[] join(byte[] ... params) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] res = null;
        try {
            for (int i = 0; i < params.length; ++i) {
                baos.write(params[i]);
            }
            res = baos.toByteArray();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return res;
    }

    private static byte[] sm3hash(byte[] ... params) {
        byte[] res = null;
        try {
            res = SM3Digest.Hash(SM2.join(params));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return res;
    }

    private static byte[] ZA(String IDA, ECPoint aPublicKey) {
        byte[] idaBytes = IDA.getBytes();
        int entlenA = idaBytes.length * 8;
        byte[] ENTLA = new byte[]{(byte)(entlenA & 0xFF00), (byte)(entlenA & 0xFF)};
        byte[] ZA = SM2.sm3hash(ENTLA, idaBytes, SM2.bytesLenTo32(a.toByteArray()), SM2.bytesLenTo32(b.toByteArray()), SM2.bytesLenTo32(gx.toByteArray()), SM2.bytesLenTo32(gy.toByteArray()), SM2.bytesLenTo32(aPublicKey.getXCoord().toBigInteger().toByteArray()), SM2.bytesLenTo32(aPublicKey.getYCoord().toBigInteger().toByteArray()));
        return ZA;
    }

    public static Signature sign(String M, String IDA, SM2KeyPair keyPair) throws UnsupportedEncodingException {
        BigInteger k;
        BigInteger r;
        byte[] ZA = SM2.ZA(IDA, keyPair.getPublicKey());
        byte[] M_ = SM2.join(ZA, M.getBytes("ISO8859-1"));
        BigInteger e = new BigInteger(1, SM2.sm3hash(new byte[][]{M_}));
        do {
            k = SM2.random(n);
            ECPoint p1 = G.multiply(k).normalize();
            BigInteger x1 = p1.getXCoord().toBigInteger();
            r = e.add(x1);
        } while ((r = r.mod(n)).equals(BigInteger.ZERO) || r.add(k).equals(n));
        BigInteger s = keyPair.getPrivateKey().add(BigInteger.ONE).modInverse(n).multiply(k.subtract(r.multiply(keyPair.getPrivateKey())).mod(n)).mod(n);
        return new Signature(r, s);
    }

    public static byte[] signWithBytes(String M, String IDA, SM2KeyPair keyPair) throws UnsupportedEncodingException {
        Signature sign = SM2.sign(M, IDA, keyPair);
        return sign.toByte();
    }

    public static boolean verify(String M, Signature signature, String IDA, ECPoint aPublicKey) throws UnsupportedEncodingException {
        ECPoint p2;
        if (!SM2.between(signature.r, BigInteger.ONE, n)) {
            return false;
        }
        if (!SM2.between(signature.s, BigInteger.ONE, n)) {
            return false;
        }
        byte[] M_ = SM2.join(SM2.ZA(IDA, aPublicKey), M.getBytes("ISO8859-1"));
        BigInteger e = new BigInteger(1, SM2.sm3hash(new byte[][]{M_}));
        BigInteger t = signature.r.add(signature.s).mod(n);
        if (t.equals(BigInteger.ZERO)) {
            return false;
        }
        ECPoint p1 = G.multiply(signature.s).normalize();
        BigInteger x1 = p1.add(p2 = aPublicKey.multiply(t).normalize()).normalize().getXCoord().toBigInteger();
        BigInteger R = e.add(x1).mod(n);
        return R.equals(signature.r);
    }

    public static boolean verify(String M, byte[] signature, String IDA, ECPoint aPublicKey) throws UnsupportedEncodingException {
        ECPoint p2;
        byte[] rBytes = Arrays.copyOfRange(signature, 0, 32);
        byte[] sBytes = Arrays.copyOfRange(signature, 32, 64);
        rBytes = SM2.bytesLenPreHandle(rBytes);
        sBytes = SM2.bytesLenPreHandle(sBytes);
        BigInteger r = new BigInteger(rBytes);
        BigInteger s = new BigInteger(sBytes);
        if (!SM2.between(r, BigInteger.ONE, n)) {
            return false;
        }
        if (!SM2.between(s, BigInteger.ONE, n)) {
            return false;
        }
        byte[] M_ = SM2.join(SM2.ZA(IDA, aPublicKey), M.getBytes("ISO8859-1"));
        BigInteger e = new BigInteger(1, SM2.sm3hash(new byte[][]{M_}));
        BigInteger t = r.add(s).mod(n);
        if (t.equals(BigInteger.ZERO)) {
            return false;
        }
        ECPoint p1 = G.multiply(s).normalize();
        BigInteger x1 = p1.add(p2 = aPublicKey.multiply(t).normalize()).normalize().getXCoord().toBigInteger();
        BigInteger R = e.add(x1).mod(n);
        return R.equals(r);
    }

    public static boolean verify(byte[] msg, byte[] sign, KeyMember member) throws UnsupportedEncodingException {
        byte[] pubKeyXBytes = new byte[32];
        byte[] pubKeyYBytes = new byte[32];
        System.arraycopy(member.getRawPKey(), 1, pubKeyXBytes, 0, 32);
        System.arraycopy(member.getRawPKey(), 33, pubKeyYBytes, 0, 32);
        pubKeyXBytes = SM2.bytesLenPreHandle(pubKeyXBytes);
        pubKeyYBytes = SM2.bytesLenPreHandle(pubKeyYBytes);
        BigInteger x = new BigInteger(pubKeyXBytes);
        BigInteger y = new BigInteger(pubKeyYBytes);
        ECPoint publicKey = curve.createPoint(x, y);
        return SM2.verify(new String(msg, "ISO8859-1"), sign, "1234567812345678", publicKey);
    }

    private static byte[] bytesLenPreHandle(byte[] bytes) {
        if (new BigInteger(bytes).signum() == -1) {
            byte[] rBytesWithLen33 = new byte[33];
            System.arraycopy(bytes, 0, rBytesWithLen33, 1, 32);
            bytes = rBytesWithLen33;
        }
        return bytes;
    }

    private static byte[] bytesLenTo32(byte[] bytes) {
        if (bytes.length > 33) {
            throw new EncException("The length of bytes must be less than or equal to 33");
        }
        if (bytes.length == 33) {
            byte[] rBytesWithLen32 = new byte[32];
            System.arraycopy(bytes, 1, rBytesWithLen32, 0, 32);
            bytes = rBytesWithLen32;
        } else {
            byte[] rBytesWithLen32 = new byte[32];
            for (int i = 0; i < rBytesWithLen32.length - bytes.length; ++i) {
                rBytesWithLen32[i] = 0;
            }
            System.arraycopy(bytes, 0, rBytesWithLen32, rBytesWithLen32.length - bytes.length, bytes.length);
            bytes = rBytesWithLen32;
        }
        return bytes;
    }

    public static BigInteger bigIntegerPreHandle(BigInteger bigInteger) {
        if (bigInteger.signum() == -1) {
            byte[] rBytesWithLen33 = new byte[33];
            System.arraycopy(bigInteger.toByteArray(), 0, rBytesWithLen33, 1, 32);
            bigInteger = new BigInteger(rBytesWithLen33);
        }
        return bigInteger;
    }

    public static byte[] getRawPubKey(ECPoint pubKey) {
        byte[] pubKeyBytes = new byte[65];
        pubKeyBytes[0] = 4;
        byte[] pubKeyXBytes = pubKey.getAffineXCoord().toBigInteger().toByteArray();
        byte[] pubKeyYBytes = pubKey.getAffineYCoord().toBigInteger().toByteArray();
        if (pubKeyXBytes.length == 33) {
            System.arraycopy(pubKeyXBytes, 1, pubKeyBytes, 1, 32);
        } else {
            System.arraycopy(pubKeyXBytes, 0, pubKeyBytes, 1, 32);
        }
        if (pubKeyYBytes.length == 33) {
            System.arraycopy(pubKeyYBytes, 1, pubKeyBytes, 33, 32);
        } else {
            System.arraycopy(pubKeyYBytes, 0, pubKeyBytes, pubKeyBytes.length - pubKeyYBytes.length, pubKeyYBytes.length);
        }
        return pubKeyBytes;
    }

    public static SM2KeyPair getSM2KeyPair() {
        SM2 sm = new SM2();
        return sm.generateKeyPair();
    }

    public static byte[] getRawSkey(SM2KeyPair sm2KeyPair) {
        BigInteger priKey = sm2KeyPair.getPrivateKey();
        byte[] priKeyBytes = priKey.toByteArray();
        if (priKey.toByteArray().length == 33) {
            priKeyBytes = Arrays.copyOfRange(priKey.toByteArray(), 1, 33);
        }
        return priKeyBytes;
    }

    public static byte[] getRawPubKey(SM2KeyPair sm2KeyPair) {
        ECPoint pubKey = sm2KeyPair.getPublicKey();
        return SM2.getRawPubKey(pubKey);
    }

    static {
        w = (int)Math.ceil((double)n.bitLength() * 1.0 / 2.0) - 1;
        _2w = new BigInteger("2").pow(w);
        SM3 = new SM3Digest();
        random = new SecureRandom();
        curve = new ECCurve.Fp(p, a, b);
        G = curve.createPoint(gx, gy);
    }

    public static class Signature {
        BigInteger r;
        BigInteger s;

        public Signature(BigInteger r, BigInteger s) {
            this.r = r;
            this.s = s;
        }

        public String toString() {
            return this.r.toString(16) + this.s.toString(16);
        }

        public byte[] toByte() {
            byte[] sign = new byte[64];
            byte[] rBytes = this.r.toByteArray();
            byte[] sBytes = this.s.toByteArray();
            if (rBytes.length == 33) {
                System.arraycopy(rBytes, 1, sign, 0, 32);
            } else {
                System.arraycopy(rBytes, 0, sign, 0, 32);
            }
            if (sBytes.length == 33) {
                System.arraycopy(sBytes, 1, sign, 32, 32);
            } else {
                System.arraycopy(sBytes, 0, sign, 32, 32);
            }
            return sign;
        }
    }
}

