/*
 * Decompiled with CFR 0.152.
 */
package cn.bitfactory.encryption.utils.hash;

import cn.bitfactory.encryption.exception.EncException;
import cn.bitfactory.encryption.model.KeyType;
import cn.bitfactory.encryption.utils.hash.SM3Digest;
import cn.bitfactory.encryption.utils.hash.Sha256;
import cn.bitfactory.encryption.utils.hash.model.HashType;
import cn.bitfactory.encryption.utils.hex.HexFormat;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class HashUtil {
    public static String GenerateHashHex(byte[] src, HashType type) {
        String hashHex = null;
        switch (type) {
            case SHA256: {
                Sha256 sha256 = new Sha256(src);
                byte[] hash = sha256.finish();
                hashHex = HexFormat.byteToHex(hash).toLowerCase();
                break;
            }
            case SM3: {
                byte[] hash = SM3Digest.Hash(src);
                hashHex = HexFormat.byteToHex(hash).toLowerCase();
                break;
            }
            default: {
                throw new EncException("type does not exist");
            }
        }
        return hashHex;
    }

    public static byte[] CalHash(KeyType type, byte[] data) {
        byte[] result = null;
        if (type == KeyType.ED25519) {
            MessageDigest sha256 = null;
            try {
                sha256 = MessageDigest.getInstance("SHA-256");
            }
            catch (NoSuchAlgorithmException e) {
                e.printStackTrace();
            }
            sha256.update(data);
            result = sha256.digest();
        } else {
            result = SM3Digest.Hash(data);
        }
        return result;
    }
}

