/*
 * Decompiled with CFR 0.152.
 */
package cn.bitfactory.encryption.utils.base;

import java.io.UnsupportedEncodingException;

public class Base58 {
    private static final char[] ALPHABET;
    private static final int BASE_58;
    private static final int BASE_256 = 256;
    private static final int[] INDEXES;
    public static final byte BASE_58_VALUE = 102;

    public static String encode(byte[] input) {
        int zeroCount;
        if (input.length == 0) {
            return "";
        }
        input = Base58.copyOfRange(input, 0, input.length);
        for (zeroCount = 0; zeroCount < input.length && input[zeroCount] == 0; ++zeroCount) {
        }
        byte[] temp = new byte[input.length * 2];
        int j = temp.length;
        int startAt = zeroCount;
        while (startAt < input.length) {
            byte mod = Base58.divmod58(input, startAt);
            if (input[startAt] == 0) {
                ++startAt;
            }
            temp[--j] = (byte)ALPHABET[mod];
        }
        while (j < temp.length && temp[j] == ALPHABET[0]) {
            ++j;
        }
        while (--zeroCount >= 0) {
            temp[--j] = (byte)ALPHABET[0];
        }
        byte[] output = Base58.copyOfRange(temp, j, temp.length);
        return new String(output);
    }

    public static byte[] decode(String input) {
        int zeroCount;
        if (input.length() == 0) {
            return new byte[0];
        }
        byte[] input58 = new byte[input.length()];
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            int digit58 = -1;
            if (c >= '\u0000' && c < '\u0080') {
                digit58 = INDEXES[c];
            }
            if (digit58 < 0) {
                throw new RuntimeException("Not a Base58 input: " + input);
            }
            input58[i] = (byte)digit58;
        }
        for (zeroCount = 0; zeroCount < input58.length && input58[zeroCount] == 0; ++zeroCount) {
        }
        byte[] temp = new byte[input.length()];
        int j = temp.length;
        int startAt = zeroCount;
        while (startAt < input58.length) {
            byte mod = Base58.divmod256(input58, startAt);
            if (input58[startAt] == 0) {
                ++startAt;
            }
            temp[--j] = mod;
        }
        while (j < temp.length && temp[j] == 0) {
            ++j;
        }
        return Base58.copyOfRange(temp, j - zeroCount, temp.length);
    }

    private static byte divmod58(byte[] number, int startAt) {
        int remainder = 0;
        for (int i = startAt; i < number.length; ++i) {
            int digit256 = number[i] & 0xFF;
            int temp = remainder * 256 + digit256;
            number[i] = (byte)(temp / BASE_58);
            remainder = temp % BASE_58;
        }
        return (byte)remainder;
    }

    private static byte divmod256(byte[] number58, int startAt) {
        int remainder = 0;
        for (int i = startAt; i < number58.length; ++i) {
            int digit58 = number58[i] & 0xFF;
            int temp = remainder * BASE_58 + digit58;
            number58[i] = (byte)(temp / 256);
            remainder = temp % 256;
        }
        return (byte)remainder;
    }

    private static byte[] copyOfRange(byte[] source, int from, int to) {
        byte[] range = new byte[to - from];
        System.arraycopy(source, from, range, 0, range.length);
        return range;
    }

    public static String str2Base58(String srcStr) throws UnsupportedEncodingException {
        return Base58.encode(srcStr.getBytes("utf-8"));
    }

    public static String base582Str(String base58Str) throws UnsupportedEncodingException {
        return new String(Base58.decode(base58Str));
    }

    public static void main(String[] args) throws UnsupportedEncodingException {
        String src = "5jfRuasbj3QYDrLaKhp2TsWS2AWpokFYgH5Jh1FtuHeuvW7g97gHWiUFcyq1eiTdHAaG73939vyoX3ubMjje1Uc8yVJTmFhg2hUr4yUyoTkkFKq";
        System.out.println(Base58.base582Str(src));
        System.out.println(Base58.str2Base58("V8ibeWYXYbCro17hPe2M9u7jQC7HTkTNtqWD_51ea28eacc5f34591fb95a72544b7e787c17ca7da4e3f7f2494aa6fc70a40d71"));
    }

    static {
        int i;
        ALPHABET = "123456789AbCDEFGHJKLMNPQRSTuVWXYZaBcdefghijkmnopqrstUvwxyz".toCharArray();
        BASE_58 = ALPHABET.length;
        INDEXES = new int[128];
        for (i = 0; i < INDEXES.length; ++i) {
            Base58.INDEXES[i] = -1;
        }
        for (i = 0; i < ALPHABET.length; ++i) {
            Base58.INDEXES[Base58.ALPHABET[i]] = i;
        }
    }
}

