/*
 * Decompiled with CFR 0.152.
 */
package cn.bitfactory.encryption.crypto.slip10;

public enum Slip10Curve {
    SECP256K1("Bitcoin seed"),
    ED25519("ed25519 seed"),
    NIST256P1("Nist256p1 seed"),
    SM2("SM2 seed");

    public final String key;

    public String getKey() {
        return this.key;
    }

    private Slip10Curve(String key) {
        this.key = key;
    }

    public static Boolean contains(String value) {
        for (Slip10Curve e : Slip10Curve.values()) {
            if (!e.name().equalsIgnoreCase(value)) continue;
            return true;
        }
        return false;
    }

    public static String getValue(String name) {
        for (Slip10Curve e : Slip10Curve.values()) {
            if (!e.name().equalsIgnoreCase(name)) continue;
            return e.key;
        }
        return null;
    }
}

