/*
 * Decompiled with CFR 0.152.
 */
package cn.bitfactory.encryption.crypto.slip10;

import cn.bitfactory.encryption.crypto.slip10.Keys;
import cn.bitfactory.encryption.crypto.slip10.Slip10Curve;
import java.math.BigInteger;
import java.security.Provider;
import java.security.Security;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.SHA512Digest;
import org.bouncycastle.crypto.macs.HMac;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.jce.ECNamedCurveTable;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.spec.ECNamedCurveParameterSpec;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.math.ec.FixedPointCombMultiplier;
import org.bouncycastle.util.Arrays;

public class HDKey {
    private static final long HARDENED_OFFSET = 0x80000000L;

    public Keys getMasterKeyFromSeed(Slip10Curve curve, String seedHex) {
        byte[] seed = this.hexStringToByteArray(seedHex);
        byte[] I = this.hmacSha512(curve.key.getBytes(), seed);
        byte[] IL = Arrays.copyOfRange((byte[])I, (int)0, (int)32);
        byte[] IR = Arrays.copyOfRange((byte[])I, (int)32, (int)64);
        BigInteger n = this.getCurveNValue(curve);
        BigInteger privateKeyInt = new BigInteger(1, IL);
        if (curve != Slip10Curve.ED25519 && (privateKeyInt.equals(BigInteger.ZERO) || privateKeyInt.compareTo(n) >= 0)) {
            return this.getMasterKeyFromSeed(curve, this.byteArrayToHexString(IR));
        }
        return new Keys(this.byteArrayToHexString(IL), this.byteArrayToHexString(IR));
    }

    public Keys deriveKeyByPath(Slip10Curve curve, String path, String seedHex) throws Exception {
        String[] segments;
        Keys masterKeys = this.getMasterKeyFromSeed(curve, seedHex);
        for (String segment : segments = this.getPathSegments(path)) {
            boolean isHardened = segment.endsWith("'");
            long index = Long.valueOf(isHardened ? String.valueOf(Long.valueOf(segment.substring(0, segment.length() - 1)) + 0x80000000L) : segment);
            masterKeys = this.getCKDPriv(masterKeys, index, curve);
        }
        return masterKeys;
    }

    private Keys getCKDPriv(Keys keys, Long index, Slip10Curve curve) throws Exception {
        byte[] data;
        byte[] kpar = this.hexStringToByteArray(keys.getKey());
        byte[] cpar = this.hexStringToByteArray(keys.getChainCode());
        Boolean isHardened = index >= 0x80000000L;
        if (isHardened.booleanValue()) {
            data = Arrays.concatenate((byte[])new byte[]{0}, (byte[])kpar, (byte[])this.ser32(index));
        } else {
            if (curve == Slip10Curve.ED25519) {
                throw new UnsupportedOperationException("Non-hardened key derivation is not supported for ED25519");
            }
            ECPoint point = this.point(this.hexStringToByteArray(keys.getKey()), curve);
            data = Arrays.concatenate((byte[])point.getEncoded(true), (byte[])this.ser32(index));
        }
        byte[] I = this.hmacSha512(cpar, data);
        return this.handleCKDPriv(keys, index, curve, I);
    }

    private Keys handleCKDPriv(Keys keys, Long index, Slip10Curve curve, byte[] I) {
        byte[] IL = Arrays.copyOfRange((byte[])I, (int)0, (int)32);
        byte[] IR = Arrays.copyOfRange((byte[])I, (int)32, (int)64);
        if (curve == Slip10Curve.ED25519) {
            return new Keys(this.byteArrayToHexString(IL), this.byteArrayToHexString(IR));
        }
        BigInteger n = this.getCurveNValue(curve);
        BigInteger ki = new BigInteger(1, IL);
        BigInteger kpar = new BigInteger(1, this.hexStringToByteArray(keys.getKey()));
        BigInteger newKeyBigInt = ki.add(kpar).mod(n);
        String newKey = newKeyBigInt.toString(16);
        newKey = HDKey.padHexString(newKey, 64);
        if (ki.compareTo(n) >= 0 || newKeyBigInt.equals(BigInteger.ZERO)) {
            byte[] data = Arrays.concatenate((byte[])new byte[]{1}, (byte[])IR, (byte[])this.ser32(index));
            byte[] IPrime = this.hmacSha512(this.hexStringToByteArray(keys.getChainCode()), data);
            return this.handleCKDPriv(keys, index, curve, IPrime);
        }
        return new Keys(newKey, this.byteArrayToHexString(IR));
    }

    private byte[] hmacSha512(byte[] key, byte[] data) {
        HMac hmac = new HMac((Digest)new SHA512Digest());
        hmac.init((CipherParameters)new KeyParameter(key));
        hmac.update(data, 0, data.length);
        byte[] output = new byte[hmac.getMacSize()];
        hmac.doFinal(output, 0);
        return output;
    }

    private ECNamedCurveParameterSpec getCurveParams(Slip10Curve curve) {
        switch (curve) {
            case SECP256K1: {
                return ECNamedCurveTable.getParameterSpec((String)"secp256k1");
            }
            case SM2: {
                return ECNamedCurveTable.getParameterSpec((String)"sm2p256v1");
            }
        }
        throw new UnsupportedOperationException("Curve not supported");
    }

    private ECPoint point(byte[] kpar, Slip10Curve curve) throws Exception {
        if (curve == Slip10Curve.ED25519) {
            throw new Exception("Non-hardened key derivation not supported for Ed25519");
        }
        ECNamedCurveParameterSpec curveParams = this.getCurveParams(curve);
        ECDomainParameters domainParams = new ECDomainParameters(curveParams.getCurve(), curveParams.getG(), curveParams.getN(), curveParams.getH());
        FixedPointCombMultiplier multiplier = new FixedPointCombMultiplier();
        return multiplier.multiply(domainParams.getG(), new BigInteger(1, kpar));
    }

    private String[] getPathSegments(String path) {
        String[] segments = path.split("/");
        String[] pathSegments = new String[segments.length - 1];
        for (int i = 1; i < segments.length; ++i) {
            pathSegments[i - 1] = segments[i];
        }
        return pathSegments;
    }

    private BigInteger getCurveNValue(Slip10Curve curve) {
        switch (curve) {
            case SECP256K1: {
                return new BigInteger("FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEBAAEDCE6AF48A03BBFD25E8CD0364141", 16);
            }
            case ED25519: {
                return new BigInteger("1000000000000000000000000000000014DEF9DEA2F79CD65812631A5CF5D3ED", 16);
            }
            case SM2: {
                return new BigInteger("FFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFF7203DF6B21C6052B53BBF40939D54123", 16);
            }
        }
        throw new UnsupportedOperationException("Invalid curve");
    }

    private byte[] ser32(long i) {
        if (i < 0L || i > 0xFFFFFFFFL) {
            throw new IllegalArgumentException("Invalid integer value");
        }
        return new byte[]{(byte)(i >> 24 & 0xFFL), (byte)(i >> 16 & 0xFFL), (byte)(i >> 8 & 0xFFL), (byte)(i & 0xFFL)};
    }

    private byte[] hexStringToByteArray(String hex) {
        hex = hex.replaceAll("0x", "");
        int len = hex.length();
        byte[] data = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            data[i / 2] = (byte)((Character.digit(hex.charAt(i), 16) << 4) + Character.digit(hex.charAt(i + 1), 16));
        }
        return data;
    }

    private String byteArrayToHexString(byte[] bytes) {
        String hexStr = String.format("%02X", new BigInteger(1, bytes)).toLowerCase();
        return HDKey.padHexString(hexStr, 64);
    }

    public static String padHexString(String hexString, int fixedLength) {
        int currentLength = hexString.length();
        if (currentLength >= fixedLength) {
            return hexString;
        }
        int numberOfZerosToPad = fixedLength - currentLength;
        StringBuilder paddedHex = new StringBuilder(hexString);
        for (int i = 0; i < numberOfZerosToPad; ++i) {
            paddedHex.insert(0, '0');
        }
        return paddedHex.toString();
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

