/*
 * Decompiled with CFR 0.152.
 */
package cn.bitfactory.encryption.crypto.mnemonic;

import cn.bitfactory.encryption.crypto.slip10.HDKey;
import cn.bitfactory.encryption.crypto.slip10.Keys;
import cn.bitfactory.encryption.crypto.slip10.Slip10Curve;
import cn.bitfactory.encryption.exception.EncException;
import cn.bitfactory.encryption.key.PrivateKeyManager;
import cn.bitfactory.encryption.model.KeyType;
import java.util.List;
import org.bitcoinj.crypto.MnemonicCode;
import org.bitcoinj.crypto.MnemonicException;
import org.bouncycastle.util.encoders.Hex;

public class Mnemonic {
    public static List<String> generateMnemonicCode(byte[] random) throws EncException {
        List mnemonicCodes;
        if (random.length != 16) {
            throw new EncException("The length of random must be 16");
        }
        try {
            mnemonicCodes = MnemonicCode.INSTANCE.toMnemonic(random);
        }
        catch (MnemonicException.MnemonicLengthException e) {
            throw new EncException(e.getMessage());
        }
        if (null == mnemonicCodes || mnemonicCodes.size() == 0) {
            throw new EncException("Failed to generate mnemonic codes");
        }
        return mnemonicCodes;
    }

    public static String generatePrivateKeyByMnemonicCodeAndKeyTypeAndHDPath(List<String> mnemonicCodes, KeyType keyType, String hdPath) throws Exception {
        Slip10Curve curveSeed;
        if (null == mnemonicCodes || mnemonicCodes.size() == 0) {
            throw new EncException("The size of mnemonicCodes must be bigger than or equal to 0");
        }
        if (null == hdPath) {
            throw new EncException("The size of hdPaths must be bigger than or equal to 0");
        }
        byte[] seed = MnemonicCode.toSeed(mnemonicCodes, (String)"");
        switch (keyType) {
            case ED25519: {
                curveSeed = Slip10Curve.ED25519;
                break;
            }
            case SM2: {
                curveSeed = Slip10Curve.SM2;
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + (Object)((Object)keyType));
            }
        }
        HDKey hdKey = new HDKey();
        Keys resultKeys = hdKey.deriveKeyByPath(curveSeed, hdPath, Hex.toHexString((byte[])seed));
        PrivateKeyManager privateKey = new PrivateKeyManager(Hex.decode((String)resultKeys.getKey()), keyType);
        return privateKey.getEncPrivateKey();
    }
}

