/*
 * Decompiled with CFR 0.152.
 */
package cn.caict.encryption.utils.sm2;

import cn.caict.encryption.exception.EncException;
import cn.caict.encryption.key.PrivateKey;
import cn.caict.encryption.model.KeyMember;
import cn.caict.encryption.model.KeyType;
import cn.caict.encryption.utils.hash.SM3Digest;
import cn.caict.encryption.utils.hex.HexFormat;
import cn.caict.encryption.utils.sm2.SM2KeyPair;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.Arrays;
import org.bouncycastle.crypto.DerivationParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.ExtendedDigest;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.digests.ShortenedDigest;
import org.bouncycastle.crypto.generators.KDF1BytesGenerator;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ISO18033KDFParameters;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.math.ec.ECPoint;

public class SM2 {
    private static BigInteger n = new BigInteger("FFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFF7203DF6B21C6052B53BBF40939D54123", 16);
    private static BigInteger p = new BigInteger("FFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000FFFFFFFFFFFFFFFF", 16);
    private static BigInteger a = new BigInteger("FFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000FFFFFFFFFFFFFFFC", 16);
    private static BigInteger b = new BigInteger("28E9FA9E9D9F5E344D5A9E4BCF6509A7F39789F515AB8F92DDBCBD414D940E93", 16);
    private static BigInteger gx = new BigInteger("32C4AE2C1F1981195F9904466A39C9948FE30BBFF2660BE1715A4589334C74C7", 16);
    private static BigInteger gy = new BigInteger("BC3736A2F4F6779C59BDCEE36B692153D0A9877CC62A474002DF32E52139F0A0", 16);
    private static ECDomainParameters ecc_bc_spec;
    private static int w;
    private static BigInteger _2w;
    private static final int DIGEST_LENGTH = 32;
    private static SM3Digest SM3;
    private static SecureRandom random;
    public static ECCurve.Fp curve;
    public static ECPoint G;

    private static BigInteger random(BigInteger max) {
        BigInteger r = new BigInteger(256, random);
        while (r.compareTo(max) >= 0) {
            r = new BigInteger(128, random);
        }
        return r;
    }

    private static boolean between(BigInteger param, BigInteger min, BigInteger max) {
        return param.compareTo(min) >= 0 && param.compareTo(max) < 0;
    }

    private boolean checkPublicKey(ECPoint publicKey) {
        if (!publicKey.isInfinity()) {
            BigInteger x = publicKey.getXCoord().toBigInteger();
            BigInteger y = publicKey.getYCoord().toBigInteger();
            if (SM2.between(x, new BigInteger("0"), p) && SM2.between(y, new BigInteger("0"), p)) {
                BigInteger xResult = x.pow(3).add(a.multiply(x)).add(b).mod(p);
                BigInteger yResult = y.pow(2).mod(p);
                if (yResult.equals(xResult) && publicKey.multiply(n).isInfinity()) {
                    return true;
                }
            }
        }
        return false;
    }

    public SM2KeyPair generateKeyPair() {
        BigInteger d = SM2.random(n.subtract(new BigInteger("1")));
        SM2KeyPair keyPair = new SM2KeyPair(G.multiply(d).normalize(), d);
        if (this.checkPublicKey(keyPair.getPublicKey())) {
            return keyPair;
        }
        return null;
    }

    public SM2() {
        ecc_bc_spec = new ECDomainParameters((ECCurve)curve, G, n);
    }

    private static byte[] join(byte[] ... params) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] res = null;
        try {
            for (int i = 0; i < params.length; ++i) {
                baos.write(params[i]);
            }
            res = baos.toByteArray();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return res;
    }

    private static byte[] sm3hash(byte[] ... params) {
        byte[] res = null;
        try {
            res = SM3Digest.Hash(SM2.join(params));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return res;
    }

    private static byte[] ZA(String IDA, ECPoint aPublicKey) {
        byte[] idaBytes = IDA.getBytes();
        int entlenA = idaBytes.length * 8;
        byte[] ENTLA = new byte[]{(byte)(entlenA & 0xFF00), (byte)(entlenA & 0xFF)};
        byte[] ZA = SM2.sm3hash(ENTLA, idaBytes, SM2.bytesLenFrom33To32(a.toByteArray()), SM2.bytesLenFrom33To32(b.toByteArray()), SM2.bytesLenFrom33To32(gx.toByteArray()), SM2.bytesLenFrom33To32(gy.toByteArray()), SM2.bytesLenFrom33To32(aPublicKey.getXCoord().toBigInteger().toByteArray()), SM2.bytesLenFrom33To32(aPublicKey.getYCoord().toBigInteger().toByteArray()));
        return ZA;
    }

    public static Signature sign(String M, String IDA, SM2KeyPair keyPair) throws UnsupportedEncodingException {
        BigInteger k;
        BigInteger r;
        byte[] ZA = SM2.ZA(IDA, keyPair.getPublicKey());
        byte[] M_ = SM2.join(ZA, M.getBytes("ISO8859-1"));
        BigInteger e = new BigInteger(1, SM2.sm3hash(new byte[][]{M_}));
        do {
            k = SM2.random(n);
            ECPoint p1 = G.multiply(k).normalize();
            BigInteger x1 = p1.getXCoord().toBigInteger();
            r = e.add(x1);
        } while ((r = r.mod(n)).equals(BigInteger.ZERO) || r.add(k).equals(n));
        BigInteger s = keyPair.getPrivateKey().add(BigInteger.ONE).modInverse(n).multiply(k.subtract(r.multiply(keyPair.getPrivateKey())).mod(n)).mod(n);
        return new Signature(r, s);
    }

    public static byte[] signWithBytes(String M, String IDA, SM2KeyPair keyPair) throws UnsupportedEncodingException {
        Signature sign = SM2.sign(M, IDA, keyPair);
        return sign.toByte();
    }

    public static boolean verify(String M, Signature signature, String IDA, ECPoint aPublicKey) throws UnsupportedEncodingException {
        ECPoint p2;
        if (!SM2.between(signature.r, BigInteger.ONE, n)) {
            return false;
        }
        if (!SM2.between(signature.s, BigInteger.ONE, n)) {
            return false;
        }
        byte[] M_ = SM2.join(SM2.ZA(IDA, aPublicKey), M.getBytes("ISO8859-1"));
        BigInteger e = new BigInteger(1, SM2.sm3hash(new byte[][]{M_}));
        BigInteger t = signature.r.add(signature.s).mod(n);
        if (t.equals(BigInteger.ZERO)) {
            return false;
        }
        ECPoint p1 = G.multiply(signature.s).normalize();
        BigInteger x1 = p1.add(p2 = aPublicKey.multiply(t).normalize()).normalize().getXCoord().toBigInteger();
        BigInteger R = e.add(x1).mod(n);
        return R.equals(signature.r);
    }

    public static boolean verify(String M, byte[] signature, String IDA, ECPoint aPublicKey) throws UnsupportedEncodingException {
        ECPoint p2;
        byte[] rBytes = Arrays.copyOfRange(signature, 0, 32);
        byte[] sBytes = Arrays.copyOfRange(signature, 32, 64);
        rBytes = SM2.bytesLenPreHandle(rBytes);
        sBytes = SM2.bytesLenPreHandle(sBytes);
        BigInteger r = new BigInteger(rBytes);
        BigInteger s = new BigInteger(sBytes);
        if (!SM2.between(r, BigInteger.ONE, n)) {
            return false;
        }
        if (!SM2.between(s, BigInteger.ONE, n)) {
            return false;
        }
        byte[] M_ = SM2.join(SM2.ZA(IDA, aPublicKey), M.getBytes("ISO8859-1"));
        BigInteger e = new BigInteger(1, SM2.sm3hash(new byte[][]{M_}));
        BigInteger t = r.add(s).mod(n);
        if (t.equals(BigInteger.ZERO)) {
            return false;
        }
        ECPoint p1 = G.multiply(s).normalize();
        BigInteger x1 = p1.add(p2 = aPublicKey.multiply(t).normalize()).normalize().getXCoord().toBigInteger();
        BigInteger R = e.add(x1).mod(n);
        return R.equals(r);
    }

    public static boolean verify(byte[] msg, byte[] sign, KeyMember member) throws UnsupportedEncodingException {
        byte[] pubKeyXBytes = new byte[32];
        byte[] pubKeyYBytes = new byte[32];
        System.arraycopy(member.getRawPKey(), 1, pubKeyXBytes, 0, 32);
        System.arraycopy(member.getRawPKey(), 33, pubKeyYBytes, 0, 32);
        pubKeyXBytes = SM2.bytesLenPreHandle(pubKeyXBytes);
        pubKeyYBytes = SM2.bytesLenPreHandle(pubKeyYBytes);
        BigInteger x = new BigInteger(pubKeyXBytes);
        BigInteger y = new BigInteger(pubKeyYBytes);
        ECPoint publicKey = curve.createPoint(x, y);
        return SM2.verify(new String(msg, "ISO8859-1"), sign, "1234567812345678", publicKey);
    }

    private static byte[] bytesLenPreHandle(byte[] bytes) {
        if (new BigInteger(bytes).signum() == -1) {
            byte[] rBytesWithLen33 = new byte[33];
            System.arraycopy(bytes, 0, rBytesWithLen33, 1, 32);
            bytes = rBytesWithLen33;
        }
        return bytes;
    }

    private static byte[] bytesLenFrom33To32(byte[] bytes) {
        if (bytes.length == 33) {
            byte[] rBytesWithLen32 = new byte[32];
            System.arraycopy(bytes, 1, rBytesWithLen32, 0, 32);
            bytes = rBytesWithLen32;
        }
        return bytes;
    }

    public static BigInteger bigIntegerPreHandle(BigInteger bigInteger) {
        if (bigInteger.signum() == -1) {
            byte[] rBytesWithLen33 = new byte[33];
            System.arraycopy(bigInteger.toByteArray(), 0, rBytesWithLen33, 1, 32);
            bigInteger = new BigInteger(rBytesWithLen33);
        }
        return bigInteger;
    }

    public static byte[] getRawPubKey(ECPoint pubKey) {
        byte[] pubKeyBytes = new byte[65];
        pubKeyBytes[0] = 4;
        byte[] pubKeyXBytes = pubKey.getAffineXCoord().toBigInteger().toByteArray();
        byte[] pubKeyYBytes = pubKey.getAffineYCoord().toBigInteger().toByteArray();
        if (pubKeyXBytes.length == 33) {
            System.arraycopy(pubKeyXBytes, 1, pubKeyBytes, 1, 32);
        } else {
            System.arraycopy(pubKeyXBytes, 0, pubKeyBytes, 1, 32);
        }
        if (pubKeyYBytes.length == 33) {
            System.arraycopy(pubKeyYBytes, 1, pubKeyBytes, 33, 32);
        } else {
            System.arraycopy(pubKeyYBytes, 0, pubKeyBytes, 33, 32);
        }
        return pubKeyBytes;
    }

    public static SM2KeyPair getSM2KeyPair() {
        SM2 sm = new SM2();
        return sm.generateKeyPair();
    }

    public static byte[] getRawSkey(SM2KeyPair sm2KeyPair) {
        BigInteger priKey = sm2KeyPair.getPrivateKey();
        byte[] priKeyBytes = priKey.toByteArray();
        if (priKey.toByteArray().length == 33) {
            priKeyBytes = Arrays.copyOfRange(priKey.toByteArray(), 1, 33);
        }
        return priKeyBytes;
    }

    public static byte[] getRawPubKey(SM2KeyPair sm2KeyPair) {
        ECPoint pubKey = sm2KeyPair.getPublicKey();
        return SM2.getRawPubKey(pubKey);
    }

    public static String printHexString(byte[] b) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < b.length; ++i) {
            String hex = Integer.toHexString(b[i] & 0xFF);
            if (hex.length() == 1) {
                builder.append('0' + hex);
                hex = '0' + hex;
            }
            System.out.print(hex.toUpperCase());
            builder.append(hex);
        }
        System.out.println();
        return builder.toString();
    }

    private static void getPublicKey(String bPkey, KeyMember member) throws EncException {
        if (null == bPkey) {
            throw new EncException("public key cannot be null");
        }
        if (!HexFormat.isHexString(bPkey)) {
            throw new EncException("public key (" + bPkey + ") is invalid, please check");
        }
        KeyType type = null;
        byte[] buffPKey = HexFormat.hexToByte(bPkey);
        if (buffPKey.length < 3) {
            throw new EncException("public key (" + bPkey + ") is invalid, please check");
        }
        if (buffPKey[0] != -80) {
            throw new EncException("public key (" + bPkey + ") is invalid, please check");
        }
        if (buffPKey[1] == 101) {
            type = KeyType.ED25519;
        } else if (buffPKey[1] == 122) {
            type = KeyType.SM2;
        } else {
            throw new EncException("public key (" + bPkey + ") is invalid, please check");
        }
        if (buffPKey[2] != 102) {
            throw new EncException("public key (" + bPkey + ") is invalid, please check");
        }
        byte[] rawPKey = new byte[buffPKey.length - 3];
        System.arraycopy(buffPKey, 3, rawPKey, 0, rawPKey.length);
        member.setRawPKey(rawPKey);
        member.setKeyType(type);
    }

    private static boolean allZero(byte[] buffer) {
        for (int i = 0; i < buffer.length; ++i) {
            if (buffer[i] == 0) continue;
            return false;
        }
        return true;
    }

    private static byte[] calculateHash(BigInteger x2, byte[] M, BigInteger y2) {
        ShortenedDigest digest = new ShortenedDigest((ExtendedDigest)new SHA256Digest(), 20);
        byte[] buf = x2.toByteArray();
        digest.update(buf, 0, buf.length);
        digest.update(M, 0, M.length);
        buf = y2.toByteArray();
        digest.update(buf, 0, buf.length);
        buf = new byte[20];
        digest.doFinal(buf, 0);
        return buf;
    }

    public static byte[] encrypt(byte[] msg, String publickey) throws EncException {
        if (msg.length == 0) {
            throw new EncException("msg is null, please check");
        }
        KeyMember member = new KeyMember();
        SM2.getPublicKey(publickey, member);
        byte[] pubKeyXBytes = new byte[32];
        byte[] pubKeyYBytes = new byte[32];
        System.arraycopy(member.getRawPKey(), 1, pubKeyXBytes, 0, 32);
        System.arraycopy(member.getRawPKey(), 33, pubKeyYBytes, 0, 32);
        pubKeyXBytes = SM2.bytesLenPreHandle(pubKeyXBytes);
        pubKeyYBytes = SM2.bytesLenPreHandle(pubKeyYBytes);
        BigInteger x = new BigInteger(pubKeyXBytes);
        BigInteger y = new BigInteger(pubKeyYBytes);
        ECPoint ecPublicKey = curve.createPoint(x, y);
        return SM2.encrypt(msg, ecPublicKey);
    }

    public static byte[] encrypt(byte[] msg, ECPoint publicKey) throws EncException {
        if (msg.length == 0) {
            throw new EncException("msg is null, please check");
        }
        BigInteger k = SM2.random(n);
        ECPoint C1 = G.multiply(k);
        byte[] C1Buffer = C1.getEncoded(false);
        ECPoint kpb = publicKey.multiply(k).normalize();
        byte[] kpbBytes = kpb.getEncoded(false);
        KDF1BytesGenerator kdf = new KDF1BytesGenerator((Digest)new ShortenedDigest((ExtendedDigest)new SHA256Digest(), 20));
        byte[] t = new byte[msg.length];
        kdf.init((DerivationParameters)new ISO18033KDFParameters(kpbBytes));
        kdf.generateBytes(t, 0, t.length);
        if (SM2.allZero(t)) {
            return null;
        }
        byte[] C2 = new byte[msg.length];
        for (int i = 0; i < msg.length; ++i) {
            C2[i] = (byte)(msg[i] ^ t[i]);
        }
        byte[] C3 = SM2.calculateHash(kpb.getXCoord().toBigInteger(), msg, kpb.getYCoord().toBigInteger());
        byte[] encryptResult = new byte[C1Buffer.length + C2.length + C3.length];
        System.arraycopy(C1Buffer, 0, encryptResult, 0, C1Buffer.length);
        System.arraycopy(C2, 0, encryptResult, C1Buffer.length, C2.length);
        System.arraycopy(C3, 0, encryptResult, C1Buffer.length + C2.length, C3.length);
        return encryptResult;
    }

    public static byte[] decrypt(byte[] encryptData, String encPrivateKey) throws EncException {
        return SM2.decrypt(encryptData, PrivateKey.getRawPrivateKey(encPrivateKey));
    }

    public static byte[] decrypt(byte[] encryptData, byte[] rawPrivateKey) throws EncException {
        BigInteger priKey = new BigInteger(rawPrivateKey);
        priKey = SM2.bigIntegerPreHandle(priKey);
        return SM2.decrypt(encryptData, priKey);
    }

    public static byte[] decrypt(byte[] encryptData, BigInteger privateKey) throws EncException {
        byte[] C1Byte = new byte[65];
        System.arraycopy(encryptData, 0, C1Byte, 0, C1Byte.length);
        ECPoint C1 = curve.decodePoint(C1Byte).normalize();
        ECPoint dBC1 = C1.multiply(privateKey).normalize();
        byte[] dBC1Bytes = dBC1.getEncoded(false);
        KDF1BytesGenerator kdf = new KDF1BytesGenerator((Digest)new ShortenedDigest((ExtendedDigest)new SHA256Digest(), 20));
        int klen = encryptData.length - 65 - 20;
        byte[] t = new byte[klen];
        kdf.init((DerivationParameters)new ISO18033KDFParameters(dBC1Bytes));
        kdf.generateBytes(t, 0, t.length);
        if (SM2.allZero(t)) {
            throw new EncException("allZero, (" + t + ")  please check");
        }
        byte[] M = new byte[klen];
        for (int i = 0; i < M.length; ++i) {
            M[i] = (byte)(encryptData[C1Byte.length + i] ^ t[i]);
        }
        byte[] C3 = new byte[20];
        System.arraycopy(encryptData, encryptData.length - 20, C3, 0, 20);
        byte[] u = SM2.calculateHash(dBC1.getXCoord().toBigInteger(), M, dBC1.getYCoord().toBigInteger());
        if (Arrays.equals(u, C3)) {
            return M;
        }
        return null;
    }

    static {
        w = (int)Math.ceil((double)n.bitLength() * 1.0 / 2.0) - 1;
        _2w = new BigInteger("2").pow(w);
        SM3 = new SM3Digest();
        random = new SecureRandom();
        curve = new ECCurve.Fp(p, a, b);
        G = curve.createPoint(gx, gy);
    }

    public static class Signature {
        BigInteger r;
        BigInteger s;

        public Signature(BigInteger r, BigInteger s) {
            this.r = r;
            this.s = s;
        }

        public String toString() {
            return this.r.toString(16) + this.s.toString(16);
        }

        public byte[] toByte() {
            byte[] sign = new byte[64];
            byte[] rBytes = this.r.toByteArray();
            byte[] sBytes = this.s.toByteArray();
            if (rBytes.length == 33) {
                System.arraycopy(rBytes, 1, sign, 0, 32);
            } else {
                System.arraycopy(rBytes, 0, sign, 0, 32);
            }
            if (sBytes.length == 33) {
                System.arraycopy(sBytes, 1, sign, 32, 32);
            } else {
                System.arraycopy(sBytes, 0, sign, 32, 32);
            }
            return sign;
        }
    }
}

