/*
 * Decompiled with CFR 0.152.
 */
package cn.caict.encryption.utils.pbkdf;

import java.security.GeneralSecurityException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class PBKDF {
    public static byte[] pbkdf2(String alg, byte[] P, byte[] S, int c, int dkLen) throws GeneralSecurityException {
        Mac mac = Mac.getInstance(alg);
        mac.init(new SecretKeySpec(P, alg));
        byte[] DK = new byte[dkLen];
        PBKDF.pbkdf2(mac, S, c, DK, dkLen);
        return DK;
    }

    public static void pbkdf2(Mac mac, byte[] S, int c, byte[] DK, int dkLen) throws GeneralSecurityException {
        int hLen = mac.getMacLength();
        if ((double)dkLen > (Math.pow(2.0, 32.0) - 1.0) * (double)hLen) {
            throw new GeneralSecurityException("Requested key length too long");
        }
        byte[] U = new byte[hLen];
        byte[] T = new byte[hLen];
        byte[] block1 = new byte[S.length + 4];
        int l = (int)Math.ceil((double)dkLen / (double)hLen);
        int r = dkLen - (l - 1) * hLen;
        System.arraycopy(S, 0, block1, 0, S.length);
        for (int i = 1; i <= l; ++i) {
            block1[S.length + 0] = (byte)(i >> 24 & 0xFF);
            block1[S.length + 1] = (byte)(i >> 16 & 0xFF);
            block1[S.length + 2] = (byte)(i >> 8 & 0xFF);
            block1[S.length + 3] = (byte)(i >> 0 & 0xFF);
            mac.update(block1);
            mac.doFinal(U, 0);
            System.arraycopy(U, 0, T, 0, hLen);
            for (int j = 1; j < c; ++j) {
                mac.update(U);
                mac.doFinal(U, 0);
                for (int k = 0; k < hLen; ++k) {
                    int n = k;
                    T[n] = (byte)(T[n] ^ U[k]);
                }
            }
            System.arraycopy(T, 0, DK, (i - 1) * hLen, i == l ? r : hLen);
        }
    }
}

