/*
 * Decompiled with CFR 0.152.
 */
package cn.caict.encryption.utils.jni;

import cn.caict.encryption.utils.jni.UnsupportedPlatformException;
import java.util.regex.Pattern;

public class Platform {
    public final Arch arch;
    public final OS os;

    private Platform(Arch arch, OS os) {
        this.arch = arch;
        this.os = os;
    }

    public static Platform detect() throws UnsupportedPlatformException {
        String osArch = System.getProperty("os.arch");
        String osName = System.getProperty("os.name");
        for (Arch arch : Arch.values()) {
            if (!arch.pattern.matcher(osArch).matches()) continue;
            for (OS os : OS.values()) {
                if (!os.pattern.matcher(osName).matches()) continue;
                return new Platform(arch, os);
            }
        }
        String msg = String.format("Unsupported platform %s %s", osArch, osName);
        throw new UnsupportedPlatformException(msg);
    }

    public static enum OS {
        darwin("darwin|mac os x"),
        freebsd("freebsd"),
        linux("linux");

        Pattern pattern;

        private OS(String pattern) {
            this.pattern = Pattern.compile("\\A" + pattern + "\\Z", 2);
        }
    }

    public static enum Arch {
        x86("x86|i386"),
        x86_64("x86_64|amd64");

        Pattern pattern;

        private Arch(String pattern) {
            this.pattern = Pattern.compile("\\A" + pattern + "\\Z", 2);
        }
    }
}

