/*
 * Decompiled with CFR 0.152.
 */
package cn.caict.encryption.key;

import cn.caict.encryption.common.CheckKey;
import cn.caict.encryption.exception.EncException;
import cn.caict.encryption.model.KeyMember;
import cn.caict.encryption.model.KeyType;
import cn.caict.encryption.utils.base.Base58;
import cn.caict.encryption.utils.hex.HexFormat;
import cn.caict.encryption.utils.sm2.SM2;
import java.security.MessageDigest;
import net.i2p.crypto.eddsa.EdDSAEngine;
import net.i2p.crypto.eddsa.EdDSAPublicKey;
import net.i2p.crypto.eddsa.spec.EdDSANamedCurveSpec;
import net.i2p.crypto.eddsa.spec.EdDSANamedCurveTable;
import net.i2p.crypto.eddsa.spec.EdDSAParameterSpec;
import net.i2p.crypto.eddsa.spec.EdDSAPublicKeySpec;

public class PublicKey {
    private KeyMember keyMember = new KeyMember();
    private String chainCode = "";

    public PublicKey() {
    }

    public PublicKey(String encPublicKey) throws EncException {
        PublicKey.getPublicKey(encPublicKey, this.keyMember);
    }

    public void setEncPublicKey(String encPublicKey) throws EncException {
        PublicKey.getPublicKey(encPublicKey, this.keyMember);
    }

    public void setRawPublicKey(byte[] rawPKey) {
        this.keyMember.setRawPKey(rawPKey);
    }

    public byte[] getRawPublicKey() {
        return this.keyMember.getRawPKey();
    }

    public void setKeyType(KeyType keyType) {
        this.keyMember.setKeyType(keyType);
    }

    public KeyType getKeyType() {
        return this.keyMember.getKeyType();
    }

    public String getChainCode() {
        return this.chainCode;
    }

    public void setChainCode(String chainCode) {
        this.chainCode = chainCode;
    }

    public String getEncAddress() throws EncException {
        byte[] raw_pkey = this.keyMember.getRawPKey();
        if (null == raw_pkey) {
            throw new EncException("public key is null");
        }
        return PublicKey.encAddress(this.keyMember.getKeyType(), raw_pkey, this.chainCode);
    }

    public static String getEncAddress(String pKey, String chainCode) throws EncException {
        KeyMember member = new KeyMember();
        PublicKey.getPublicKey(pKey, member);
        return PublicKey.encAddress(member.getKeyType(), member.getRawPKey(), chainCode);
    }

    public static String getEncAddress(String pKey) throws EncException {
        KeyMember member = new KeyMember();
        PublicKey.getPublicKey(pKey, member);
        return PublicKey.encAddress(member.getKeyType(), member.getRawPKey(), "");
    }

    public static boolean isAddressValid(String encAddress) {
        return PublicKey.encAddressValid(encAddress);
    }

    public static boolean isPublicKeyValid(String encPublicKey) {
        return PublicKey.encPublicKeyValid(encPublicKey);
    }

    public boolean verify(byte[] msg, byte[] signMsg) throws EncException {
        boolean verifySuccess = PublicKey.verifyMessage(msg, signMsg, this.keyMember);
        return verifySuccess;
    }

    public static boolean verify(byte[] msg, byte[] signMsg, String encPublicKey) throws EncException {
        boolean verifySuccess = false;
        KeyMember member = new KeyMember();
        PublicKey.getPublicKey(encPublicKey, member);
        verifySuccess = PublicKey.verifyMessage(msg, signMsg, member);
        return verifySuccess;
    }

    private static void getPublicKey(String bPkey, KeyMember member) throws EncException {
        if (null == bPkey) {
            throw new EncException("public key cannot be null");
        }
        if (!HexFormat.isHexString(bPkey)) {
            throw new EncException("public key (" + bPkey + ") is invalid, please check");
        }
        KeyType type = null;
        byte[] buffPKey = HexFormat.hexToByte(bPkey);
        if (buffPKey.length < 3) {
            throw new EncException("public key (" + bPkey + ") is invalid, please check");
        }
        if (buffPKey[0] != -80) {
            throw new EncException("public key (" + bPkey + ") is invalid, please check");
        }
        if (buffPKey[1] == 101) {
            type = KeyType.ED25519;
        } else if (buffPKey[1] == 122) {
            type = KeyType.SM2;
        } else {
            throw new EncException("public key (" + bPkey + ") is invalid, please check");
        }
        if (buffPKey[2] != 102) {
            throw new EncException("public key (" + bPkey + ") is invalid, please check");
        }
        byte[] rawPKey = new byte[buffPKey.length - 3];
        System.arraycopy(buffPKey, 3, rawPKey, 0, rawPKey.length);
        member.setRawPKey(rawPKey);
        member.setKeyType(type);
    }

    private static boolean encPublicKeyValid(String encPublicKey) {
        boolean valid;
        try {
            if (null == encPublicKey) {
                throw new EncException("Invalid publicKey");
            }
            if (!HexFormat.isHexString(encPublicKey)) {
                throw new EncException("Invalid publicKey");
            }
            Object type = null;
            byte[] buffPKey = HexFormat.hexToByte(encPublicKey);
            if (buffPKey.length < 3 || buffPKey[0] != -80 || buffPKey[1] != 101 && buffPKey[1] != 122 || buffPKey[2] != 102) {
                throw new EncException("Invalid publicKey");
            }
            valid = true;
        }
        catch (Exception exception) {
            valid = false;
        }
        return valid;
    }

    private static String encAddress(KeyType type, byte[] raw_pkey, String chainCode) {
        byte[] buff = new byte[22];
        byte[] hashPkey = CheckKey.CalHash(type, raw_pkey);
        System.arraycopy(hashPkey, 10, buff, 0, 22);
        String encAddress = Base58.encode(buff);
        if (chainCode.isEmpty()) {
            switch (type) {
                case ED25519: {
                    return "did:bid:ef" + encAddress;
                }
                case SM2: {
                    return "did:bid:zf" + encAddress;
                }
            }
            throw new EncException("type does not exist");
        }
        switch (type) {
            case ED25519: {
                return "did:bid:" + chainCode + ":ef" + encAddress;
            }
            case SM2: {
                return "did:bid:" + chainCode + ":zf" + encAddress;
            }
        }
        throw new EncException("type does not exist");
    }

    private static boolean encAddressValid(String encAddress) {
        boolean valid;
        try {
            if (null == encAddress) {
                throw new EncException("Invalid address");
            }
            String[] items = encAddress.split(":");
            if (items.length != 3 && items.length != 4) {
                throw new EncException("Invalid address");
            }
            encAddress = items.length == 3 ? items[2] : items[3];
            String prifx = encAddress.substring(0, 2);
            if (!prifx.equals("ef") && !prifx.equals("zf")) {
                throw new EncException("Invalid address");
            }
            String address = encAddress.substring(2, encAddress.length());
            byte[] base58_address = Base58.decode(address);
            if (base58_address.length != 22) {
                throw new EncException("Invalid address");
            }
            valid = true;
        }
        catch (Exception e) {
            valid = false;
        }
        return valid;
    }

    private static boolean verifyMessage(byte[] msg, byte[] sign, KeyMember member) {
        boolean verifySuccess;
        try {
            switch (member.getKeyType()) {
                case ED25519: {
                    EdDSAEngine sgr = new EdDSAEngine(MessageDigest.getInstance("SHA-512"));
                    EdDSANamedCurveSpec spec = EdDSANamedCurveTable.getByName((String)"ed25519-sha-512");
                    EdDSAPublicKeySpec eddsaPubKey = new EdDSAPublicKeySpec(member.getRawPKey(), (EdDSAParameterSpec)spec);
                    EdDSAPublicKey vKey = new EdDSAPublicKey(eddsaPubKey);
                    sgr.initVerify((java.security.PublicKey)vKey);
                    sgr.update(msg);
                    verifySuccess = sgr.verify(sign);
                    break;
                }
                case SM2: {
                    verifySuccess = SM2.verify(msg, sign, member);
                    break;
                }
                default: {
                    throw new EncException("type does not exist");
                }
            }
        }
        catch (Exception e) {
            verifySuccess = false;
        }
        return verifySuccess;
    }
}

