/*
 * Decompiled with CFR 0.152.
 */
package cn.caict.encryption.key;

import cn.caict.encryption.exception.EncException;
import cn.caict.encryption.key.PublicKey;
import cn.caict.encryption.model.KeyMember;
import cn.caict.encryption.model.KeyType;
import cn.caict.encryption.utils.base.Base58;
import cn.caict.encryption.utils.hash.SM3Digest;
import cn.caict.encryption.utils.hash.Sha256;
import cn.caict.encryption.utils.hex.HexFormat;
import cn.caict.encryption.utils.sm2.SM2;
import cn.caict.encryption.utils.sm2.SM2KeyPair;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SignatureException;
import net.i2p.crypto.eddsa.EdDSAEngine;
import net.i2p.crypto.eddsa.EdDSAPrivateKey;
import net.i2p.crypto.eddsa.EdDSAPublicKey;
import net.i2p.crypto.eddsa.KeyPairGenerator;
import net.i2p.crypto.eddsa.spec.EdDSANamedCurveSpec;
import net.i2p.crypto.eddsa.spec.EdDSANamedCurveTable;
import net.i2p.crypto.eddsa.spec.EdDSAParameterSpec;
import net.i2p.crypto.eddsa.spec.EdDSAPrivateKeySpec;
import net.i2p.crypto.eddsa.spec.EdDSAPublicKeySpec;
import org.bouncycastle.math.ec.ECPoint;

public class PrivateKey {
    private PublicKey publicKey = new PublicKey();
    private KeyMember keyMember = new KeyMember();
    private String path = "";

    public PrivateKey() throws EncException {
        this(KeyType.ED25519);
    }

    public PrivateKey(boolean isDefault, String chainCode) throws EncException {
        this(KeyType.ED25519, chainCode);
    }

    public PrivateKey(KeyType type) throws EncException {
        switch (type) {
            case ED25519: {
                KeyPairGenerator keyPairGenerator = new KeyPairGenerator();
                KeyPair keyPair = keyPairGenerator.generateKeyPair();
                EdDSAPrivateKey priKey = (EdDSAPrivateKey)keyPair.getPrivate();
                EdDSAPublicKey pubKey = (EdDSAPublicKey)keyPair.getPublic();
                this.keyMember.setRawSKey(priKey.getSeed());
                this.publicKey.setRawPublicKey(pubKey.getAbyte());
                break;
            }
            case SM2: {
                SM2KeyPair keyPair = SM2.getSM2KeyPair();
                byte[] rawSkey = SM2.getRawSkey(keyPair);
                byte[] rawPubKey = SM2.getRawPubKey(keyPair);
                this.keyMember.setRawSKey(rawSkey);
                this.publicKey.setRawPublicKey(rawPubKey);
                break;
            }
            default: {
                throw new EncException("type does not exist");
            }
        }
        this.setKeyType(type);
        this.publicKey.setKeyType(type);
    }

    public PrivateKey(KeyType type, String chainCode) throws EncException {
        switch (type) {
            case ED25519: {
                KeyPairGenerator keyPairGenerator = new KeyPairGenerator();
                KeyPair keyPair = keyPairGenerator.generateKeyPair();
                EdDSAPrivateKey priKey = (EdDSAPrivateKey)keyPair.getPrivate();
                EdDSAPublicKey pubKey = (EdDSAPublicKey)keyPair.getPublic();
                this.keyMember.setRawSKey(priKey.getSeed());
                this.publicKey.setRawPublicKey(pubKey.getAbyte());
                this.publicKey.setChainCode(chainCode);
                break;
            }
            case SM2: {
                SM2KeyPair keyPair = SM2.getSM2KeyPair();
                byte[] rawSkey = SM2.getRawSkey(keyPair);
                byte[] rawPubKey = SM2.getRawPubKey(keyPair);
                this.keyMember.setRawSKey(rawSkey);
                this.publicKey.setRawPublicKey(rawPubKey);
                this.publicKey.setChainCode(chainCode);
                break;
            }
            default: {
                throw new EncException("type does not exist");
            }
        }
        this.setKeyType(type);
        this.publicKey.setKeyType(type);
    }

    public PrivateKey(KeyType keyType, byte[] seed, String chainCode, String path) {
        switch (keyType) {
            case ED25519: {
                EdDSANamedCurveSpec spec = EdDSANamedCurveTable.getByName((String)"ed25519-sha-512");
                EdDSAPrivateKeySpec privKey = new EdDSAPrivateKeySpec(seed, (EdDSAParameterSpec)spec);
                EdDSAPublicKeySpec spec2 = new EdDSAPublicKeySpec(privKey.getA(), (EdDSAParameterSpec)spec);
                EdDSAPublicKey pDsaPublicKey = new EdDSAPublicKey(spec2);
                this.publicKey.setRawPublicKey(pDsaPublicKey.getAbyte());
                this.keyMember.setRawSKey(seed);
                this.setKeyType(keyType);
                this.publicKey.setKeyType(keyType);
                this.publicKey.setChainCode(chainCode);
                this.path = path;
                break;
            }
            case SM2: {
                BigInteger priKey = new BigInteger(seed);
                priKey = SM2.bigIntegerPreHandle(priKey);
                ECPoint pubKey = SM2.G.multiply(priKey).normalize();
                this.publicKey.setRawPublicKey(SM2.getRawPubKey(pubKey));
                this.keyMember.setRawSKey(seed);
                this.setKeyType(keyType);
                this.publicKey.setKeyType(keyType);
                this.publicKey.setChainCode(chainCode);
                this.path = path;
            }
        }
    }

    public PrivateKey(byte[] seed, String chainCode) {
        EdDSANamedCurveSpec spec = EdDSANamedCurveTable.getByName((String)"ed25519-sha-512");
        EdDSAPrivateKeySpec privKey = new EdDSAPrivateKeySpec(seed, (EdDSAParameterSpec)spec);
        EdDSAPublicKeySpec spec2 = new EdDSAPublicKeySpec(privKey.getA(), (EdDSAParameterSpec)spec);
        EdDSAPublicKey pDsaPublicKey = new EdDSAPublicKey(spec2);
        this.publicKey.setRawPublicKey(pDsaPublicKey.getAbyte());
        this.keyMember.setRawSKey(seed);
        this.setKeyType(KeyType.ED25519);
        this.publicKey.setKeyType(KeyType.ED25519);
        this.publicKey.setChainCode(chainCode);
    }

    public PrivateKey(byte[] seed) {
        EdDSANamedCurveSpec spec = EdDSANamedCurveTable.getByName((String)"ed25519-sha-512");
        EdDSAPrivateKeySpec privKey = new EdDSAPrivateKeySpec(seed, (EdDSAParameterSpec)spec);
        EdDSAPublicKeySpec spec2 = new EdDSAPublicKeySpec(privKey.getA(), (EdDSAParameterSpec)spec);
        EdDSAPublicKey pDsaPublicKey = new EdDSAPublicKey(spec2);
        this.publicKey.setRawPublicKey(pDsaPublicKey.getAbyte());
        this.keyMember.setRawSKey(seed);
        this.setKeyType(KeyType.ED25519);
        this.publicKey.setKeyType(KeyType.ED25519);
    }

    public PrivateKey(String skey) throws EncException {
        PrivateKey.getPrivateKey(skey, this.keyMember);
        this.publicKey.setKeyType(this.keyMember.getKeyType());
        byte[] rawPKey = PrivateKey.getPublicKey(this.keyMember);
        this.publicKey.setRawPublicKey(rawPKey);
        this.keyMember.setRawPKey(rawPKey);
    }

    public PrivateKey(String skey, String chainCode) throws EncException {
        PrivateKey.getPrivateKey(skey, this.keyMember);
        this.publicKey.setKeyType(this.keyMember.getKeyType());
        byte[] rawPKey = PrivateKey.getPublicKey(this.keyMember);
        this.publicKey.setRawPublicKey(rawPKey);
        this.keyMember.setRawPKey(rawPKey);
        this.publicKey.setChainCode(chainCode);
    }

    public String getPath() {
        return this.path;
    }

    public void setKeyType(KeyType keyType) {
        this.keyMember.setKeyType(keyType);
    }

    public KeyType getKeyType() {
        return this.keyMember.getKeyType();
    }

    public void setRawPrivateKey(byte[] rawSKey) {
        this.keyMember.setRawSKey(rawSKey);
    }

    public byte[] getRawPrivateKey() {
        return this.keyMember.getRawSKey();
    }

    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    public String getEncPrivateKey() throws EncException {
        byte[] rawSKey = this.keyMember.getRawSKey();
        if (rawSKey == null) {
            throw new EncException("raw private key is null");
        }
        return PrivateKey.EncPrivateKey(this.keyMember.getKeyType(), this.keyMember.getRawSKey());
    }

    public static boolean isPrivateKeyValid(String encPrivateKey) {
        return PrivateKey.encPrivateKeyValid(encPrivateKey);
    }

    public String getEncPublicKey() throws EncException {
        byte[] rawPKey = this.publicKey.getRawPublicKey();
        if (rawPKey == null) {
            throw new EncException("raw public key is null");
        }
        return PrivateKey.encPublicKey(this.keyMember.getKeyType(), rawPKey).toLowerCase();
    }

    public static String getEncPublicKey(String skey) throws EncException {
        KeyMember member = new KeyMember();
        PrivateKey.getPrivateKey(skey, member);
        byte[] rawPKey = PrivateKey.getPublicKey(member);
        return PrivateKey.encPublicKey(member.getKeyType(), rawPKey).toLowerCase();
    }

    public static boolean isPublicKeyValid(String encPublicKey) {
        return PublicKey.isPublicKeyValid(encPublicKey);
    }

    public String getEncAddress() throws EncException {
        return this.publicKey.getEncAddress();
    }

    public static String getEncAddress(String pKey, String chainCode) throws EncException {
        return PublicKey.getEncAddress(pKey, chainCode);
    }

    public static String getEncAddress(String pKey) throws EncException {
        return PublicKey.getEncAddress(pKey);
    }

    public static PrivateKey generateChildPrivate(String parentPrivateKey, String chainCode, String serviceType, long index) throws EncException {
        KeyMember member = new KeyMember();
        PrivateKey.getPrivateKey(parentPrivateKey, member);
        String path = "/0/" + chainCode + "/" + serviceType + "/" + index;
        byte[] seed = null;
        switch (member.getKeyType()) {
            case ED25519: {
                Sha256 sha256 = new Sha256((HexFormat.byteToHex(member.getRawSKey()).toLowerCase() + path).getBytes());
                seed = sha256.finish256();
                break;
            }
            case SM2: {
                String rawSrc = HexFormat.byteArrayToIntArrayString(member.getRawSKey(), ",") + path;
                byte[] hashSrc = rawSrc.getBytes();
                byte[] seedTmp = SM3Digest.Hash(hashSrc);
                String seedStr = HexFormat.byteToHex(seedTmp).toLowerCase();
                seed = HexFormat.hexToByte(seedStr);
                break;
            }
            default: {
                throw new EncException("parentPrivateKey is invalid");
            }
        }
        return new PrivateKey(member.getKeyType(), seed, chainCode, path);
    }

    public static boolean isAddressValid(String encAddress) {
        return PublicKey.isAddressValid(encAddress);
    }

    public byte[] sign(byte[] msg) throws EncException {
        return PrivateKey.signMessage(msg, this.keyMember);
    }

    public static byte[] sign(byte[] msg, String skey) throws EncException {
        KeyMember member = new KeyMember();
        PrivateKey.getPrivateKey(skey, member);
        byte[] rawPKey = PrivateKey.getPublicKey(member);
        member.setRawPKey(rawPKey);
        return PrivateKey.signMessage(msg, member);
    }

    public static byte[] getRawPrivateKey(String bSkey) throws EncException {
        try {
            if (null == bSkey) {
                throw new EncException("Private key cannot be null");
            }
            byte[] skeyTmp = Base58.decode(bSkey);
            if (skeyTmp.length <= 5) {
                throw new EncException("Private key (" + bSkey + ") is invalid");
            }
            switch (skeyTmp[3]) {
                case 101: {
                    KeyType type = KeyType.values()[0];
                    break;
                }
                case 122: {
                    KeyType type = KeyType.values()[1];
                    break;
                }
                default: {
                    throw new EncException("Private key (" + bSkey + ") is invalid");
                }
            }
            if (skeyTmp[4] != 102) {
                throw new EncException("Private key (" + bSkey + ") is invalid");
            }
            byte[] rawSKey = new byte[skeyTmp.length - 5];
            System.arraycopy(skeyTmp, 5, rawSKey, 0, rawSKey.length);
            return rawSKey;
        }
        catch (Exception e) {
            throw new EncException("Invalid privateKey");
        }
    }

    private static void getPrivateKey(String bSkey, KeyMember member) throws EncException {
        try {
            KeyType type;
            if (null == bSkey) {
                throw new EncException("Private key cannot be null");
            }
            byte[] skeyTmp = Base58.decode(bSkey);
            if (skeyTmp.length <= 5) {
                throw new EncException("Private key (" + bSkey + ") is invalid");
            }
            switch (skeyTmp[3]) {
                case 101: {
                    type = KeyType.values()[0];
                    break;
                }
                case 122: {
                    type = KeyType.values()[1];
                    break;
                }
                default: {
                    throw new EncException("Private key (" + bSkey + ") is invalid");
                }
            }
            if (skeyTmp[4] != 102) {
                throw new EncException("Private key (" + bSkey + ") is invalid");
            }
            byte[] rawSKey = new byte[skeyTmp.length - 5];
            System.arraycopy(skeyTmp, 5, rawSKey, 0, rawSKey.length);
            member.setKeyType(type);
            member.setRawSKey(rawSKey);
        }
        catch (Exception e) {
            throw new EncException("Invalid privateKey");
        }
    }

    private static byte[] getPublicKey(KeyMember member) throws EncException {
        byte[] rawPKey = null;
        switch (member.getKeyType()) {
            case ED25519: {
                EdDSANamedCurveSpec spec = EdDSANamedCurveTable.getByName((String)"ed25519-sha-512");
                EdDSAPrivateKeySpec privKey = new EdDSAPrivateKeySpec(member.getRawSKey(), (EdDSAParameterSpec)spec);
                EdDSAPublicKeySpec spec2 = new EdDSAPublicKeySpec(privKey.getA(), (EdDSAParameterSpec)spec);
                EdDSAPublicKey pDsaPublicKey = new EdDSAPublicKey(spec2);
                rawPKey = pDsaPublicKey.getAbyte();
                break;
            }
            case SM2: {
                BigInteger priKey = new BigInteger(member.getRawSKey());
                priKey = SM2.bigIntegerPreHandle(priKey);
                ECPoint pubKey = SM2.G.multiply(priKey).normalize();
                rawPKey = SM2.getRawPubKey(pubKey);
                break;
            }
            default: {
                throw new EncException("Type does not exist");
            }
        }
        return rawPKey;
    }

    private static String EncPrivateKey(KeyType type, byte[] raw_skey) throws EncException {
        if (null == raw_skey) {
            throw new EncException("Private key is null");
        }
        byte[] buff = new byte[raw_skey.length + 5];
        buff[0] = 24;
        buff[1] = -98;
        buff[2] = -103;
        System.arraycopy(raw_skey, 0, buff, 5, raw_skey.length);
        switch (type) {
            case ED25519: {
                buff[3] = 101;
                break;
            }
            case SM2: {
                buff[3] = 122;
                break;
            }
            default: {
                throw new EncException("type does not exist");
            }
        }
        buff[4] = 102;
        return Base58.encode(buff);
    }

    private static boolean encPrivateKeyValid(String encPrivateKey) {
        boolean valid;
        try {
            if (null == encPrivateKey) {
                throw new EncException("Invalid privateKey");
            }
            byte[] privateKeyTemp = Base58.decode(encPrivateKey);
            if (privateKeyTemp.length != 37 || privateKeyTemp[0] != 24 || privateKeyTemp[1] != -98 || privateKeyTemp[2] != -103 || privateKeyTemp[4] != 102) {
                throw new EncException("Invalid privateKey");
            }
            switch (privateKeyTemp[3]) {
                case 101: 
                case 122: {
                    break;
                }
                default: {
                    throw new EncException("Invalid privateKey");
                }
            }
            valid = true;
        }
        catch (Exception e) {
            valid = false;
        }
        return valid;
    }

    private static String encPublicKey(KeyType type, byte[] raw_pkey) throws EncException {
        if (null == raw_pkey) {
            throw new EncException("Public key is null");
        }
        int length = raw_pkey.length + 3;
        byte[] buff = new byte[length];
        buff[0] = -80;
        switch (type) {
            case ED25519: {
                buff[1] = 101;
                break;
            }
            case SM2: {
                buff[1] = 122;
                break;
            }
            default: {
                throw new EncException("type does not exist");
            }
        }
        buff[2] = 102;
        System.arraycopy(raw_pkey, 0, buff, 3, raw_pkey.length);
        return HexFormat.byteToHex(buff);
    }

    private static byte[] signMessage(byte[] msg, KeyMember member) throws EncException {
        if (null == member.getRawSKey()) {
            throw new EncException("Raw private key is null");
        }
        byte[] signMsg = null;
        try {
            switch (member.getKeyType()) {
                case ED25519: {
                    EdDSAEngine sgr = new EdDSAEngine(MessageDigest.getInstance("SHA-512"));
                    EdDSANamedCurveSpec spec = EdDSANamedCurveTable.getByName((String)"ed25519-sha-512");
                    EdDSAPrivateKeySpec sKeySpec = new EdDSAPrivateKeySpec(member.getRawSKey(), (EdDSAParameterSpec)spec);
                    EdDSAPrivateKey sKey = new EdDSAPrivateKey(sKeySpec);
                    sgr.initSign((java.security.PrivateKey)sKey);
                    sgr.update(msg);
                    signMsg = sgr.sign();
                    break;
                }
                case SM2: {
                    BigInteger sKey = new BigInteger(member.getRawSKey());
                    sKey = SM2.bigIntegerPreHandle(sKey);
                    SM2KeyPair keyPair = new SM2KeyPair(SM2.G.multiply(sKey).normalize(), sKey);
                    signMsg = SM2.signWithBytes(new String(msg, "ISO_8859_1"), "1234567812345678", keyPair);
                    break;
                }
                default: {
                    throw new EncException("Type does not exist");
                }
            }
        }
        catch (NoSuchAlgorithmException e) {
            throw new EncException("System error");
        }
        catch (InvalidKeyException e) {
            throw new EncException("Invalid privateKey");
        }
        catch (SignatureException e) {
            throw new EncException("Sign message failed");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return signMsg;
    }
}

