/*
 * Decompiled with CFR 0.152.
 */
package cn.caict.encryption.crypto.mnemonic;

import cn.caict.encryption.exception.EncException;
import cn.caict.encryption.key.PrivateKey;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.bitcoinj.crypto.DeterministicHierarchy;
import org.bitcoinj.crypto.DeterministicKey;
import org.bitcoinj.crypto.HDKeyDerivation;
import org.bitcoinj.crypto.HDUtils;
import org.bitcoinj.crypto.MnemonicCode;
import org.bitcoinj.crypto.MnemonicException;

public class Mnemonic {
    public static List<String> generateMnemonicCode(byte[] random) throws EncException {
        List mnemonicCodes;
        if (random.length != 16) {
            throw new EncException("The length of random must be 16");
        }
        try {
            mnemonicCodes = MnemonicCode.INSTANCE.toMnemonic(random);
        }
        catch (MnemonicException.MnemonicLengthException e) {
            throw new EncException(e.getMessage());
        }
        if (null == mnemonicCodes || mnemonicCodes.size() == 0) {
            throw new EncException("Failed to generate mnemonic codes");
        }
        return mnemonicCodes;
    }

    public static List<String> generatePrivateKeys(List<String> mnemonicCodes, List<String> hdPaths) throws EncException {
        if (null == mnemonicCodes || mnemonicCodes.size() == 0) {
            throw new EncException("The size of mnemonicCodes must be bigger than or equal to 0");
        }
        if (null == hdPaths || hdPaths.size() == 0) {
            throw new EncException("The size of hdPaths must be bigger than or equal to 0");
        }
        byte[] seed = MnemonicCode.toSeed(mnemonicCodes, (String)"");
        DeterministicKey deterministicKey = HDKeyDerivation.createMasterPrivateKey((byte[])seed);
        DeterministicHierarchy deterministicHierarchy = new DeterministicHierarchy(deterministicKey);
        ArrayList<String> privateKeys = new ArrayList<String>();
        for (String hdPath : hdPaths) {
            List keyPath = HDUtils.parsePath((String)hdPath);
            DeterministicKey childKey = deterministicHierarchy.get(keyPath, true, true);
            BigInteger privKey = childKey.getPrivKey();
            byte[] bytes = privKey.toByteArray();
            byte[] seeds = new byte[32];
            int startPos = 0;
            int length = 32;
            if (privKey.toByteArray().length == 33) {
                startPos = 1;
            }
            if (privKey.toByteArray().length == 31) {
                length = 31;
            }
            System.arraycopy(bytes, startPos, seeds, 0, length);
            PrivateKey privateKey = new PrivateKey(seeds);
            privateKeys.add(privateKey.getEncPrivateKey());
        }
        if (privateKeys.size() == 0) {
            throw new EncException("Failed to generate private key with mnemonicCodes");
        }
        return privateKeys;
    }
}

